/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.trace;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.dt.trace.DecisionTableTraceObject;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ATableTracerLeaf;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ILogicalTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTracer
extends ATableTracerLeaf {
    private int ruleIndex;
    private DecisionTableTraceObject decisionTableTraceObject;

    public RuleTracer(DecisionTableTraceObject decisionTableTraceObject, int ruleIdx) {
        this.ruleIndex = ruleIdx;
        this.decisionTableTraceObject = decisionTableTraceObject;
    }

    public String getDisplayName(int mode) {
        return "Rule: " + this.decisionTableTraceObject.getDecisionTable().getRuleName(this.ruleIndex);
    }

    public IGridRegion getGridRegion() {
        return this.getRuleTable().getSource().getRegion();
    }

    public DecisionTableTraceObject getParentTraceObject() {
        return this.decisionTableTraceObject;
    }

    public ILogicalTable getRuleTable() {
        return this.decisionTableTraceObject.getDecisionTable().getRuleByIndex(this.ruleIndex);
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.getParentTraceObject().getDecisionTable().getSyntaxNode();
    }

    public String getType() {
        return "rule";
    }

    public String getUri() {
        return this.getRuleTable().getSource().getUri();
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        ILogicalTable ruleTable = this.getRuleTable();
        ICell cell = null;
        for (int row = 0; row < ruleTable.getSource().getHeight(); row += cell.getHeight()) {
            for (int column = 0; column < ruleTable.getSource().getWidth(); column += cell.getWidth()) {
                cell = ruleTable.getSource().getCell(column, row);
                regions.add(cell.getAbsoluteRegion());
            }
        }
        return regions;
    }
}

