/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.dt.type.domains.ArrayDomainCollector;
import org.openl.rules.dt.type.domains.DateDomainCollector;
import org.openl.rules.dt.type.domains.EnumDomainCollector;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainCollector;
import org.openl.rules.dt.type.domains.StringDomainCollector;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionPropertiesDomainsCollector {
    private Map<String, IDomainCollector> domainCollectors = new HashMap<String, IDomainCollector>();
    private Map<String, IDomainAdaptor> propertiesDomains = new HashMap<String, IDomainAdaptor>();
    private DateDomainCollector dateDomainCollector = new DateDomainCollector();

    public DimensionPropertiesDomainsCollector() {
        this.initDomainCollectors();
    }

    public Map<String, IDomainAdaptor> getGatheredPropertiesDomains() {
        return new HashMap<String, IDomainAdaptor>(this.propertiesDomains);
    }

    public Set<String> getPropertiesNeedDomain() {
        return new HashSet<String>(this.domainCollectors.keySet());
    }

    public void gatherPropertiesDomains(TableSyntaxNode[] tableSyntaxNodes) {
        this.propertiesDomains.clear();
        this.gatherAllDomains(tableSyntaxNodes);
        this.applyAllDomains();
    }

    private void applyAllDomains() {
        IDomainAdaptor dateDomainAdaptor = null;
        for (String propNeedDomain : this.domainCollectors.keySet()) {
            Class<?> propertyType = TablePropertyDefinitionUtils.getPropertyTypeByPropertyName(propNeedDomain);
            IDomainCollector domainCollector = this.domainCollectors.get(propNeedDomain);
            this.applyDomain(propNeedDomain, domainCollector.getGatheredDomain());
            if (dateDomainAdaptor == null && Date.class.equals(propertyType)) {
                dateDomainAdaptor = domainCollector.getGatheredDomain();
                continue;
            }
            if (!propertyType.isArray() || !propertyType.getComponentType().isEnum()) continue;
            this.applyArrayDomains(propNeedDomain, domainCollector);
        }
        this.applyCurrentDateDomain(dateDomainAdaptor);
    }

    private void applyArrayDomains(String propNeedDomain, IDomainCollector domainCollector) {
        ArrayDomainCollector arrayCollector = (ArrayDomainCollector)domainCollector;
        IDomainAdaptor domainAdaptor = arrayCollector.getGatheredDomain();
        if (domainAdaptor != null) {
            this.propertiesDomains.put(propNeedDomain, domainAdaptor);
            for (int i = 1; i <= arrayCollector.getNumberOfDomainElements(); ++i) {
                this.propertiesDomains.put(String.format("%s%s%s", propNeedDomain, "Local", i), domainAdaptor);
            }
        }
    }

    private void applyDomain(String propNeedDomain, IDomainAdaptor gatheredDomain) {
        String key = propNeedDomain + "Local";
        if (gatheredDomain != null && !this.propertiesDomains.containsKey(key)) {
            this.propertiesDomains.put(propNeedDomain, gatheredDomain);
            this.propertiesDomains.put(key, gatheredDomain);
        }
    }

    private void applyCurrentDateDomain(IDomainAdaptor dateDomainAdaptor) {
        if (dateDomainAdaptor != null && !this.propertiesDomains.containsKey("currentDate")) {
            this.propertiesDomains.put("currentDate", dateDomainAdaptor);
        }
    }

    private void gatherAllDomains(TableSyntaxNode[] tableSyntaxNodes) {
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            for (String propNeedDomain : this.domainCollectors.keySet()) {
                IDomainCollector domainCollector = this.domainCollectors.get(propNeedDomain);
                domainCollector.gatherDomains(tsn);
            }
        }
    }

    private void initDomainCollectors() {
        for (TablePropertyDefinition property : TablePropertyDefinitionUtils.getDimensionalTableProperties()) {
            IDomainCollector domainCollector = this.getDomainCollector(property);
            if (domainCollector == null) continue;
            this.domainCollectors.put(property.getName(), domainCollector);
        }
    }

    private IDomainCollector getDomainCollector(TablePropertyDefinition property) {
        Class propertyType = property.getType().getInstanceClass();
        String propertyName = property.getName();
        IDomainCollector result = null;
        if (result == null) {
            if (Date.class.equals((Object)propertyType)) {
                this.dateDomainCollector.addPropertyToSearch(propertyName);
                result = this.dateDomainCollector;
            } else if (String.class.equals((Object)propertyType)) {
                result = new StringDomainCollector(propertyName);
            } else if (propertyType.isEnum()) {
                result = new EnumDomainCollector(propertyName);
            } else if (propertyType.isArray() && propertyType.getComponentType().isEnum()) {
                result = new ArrayDomainCollector(propertyName);
            } else if (propertyType.isArray() && String.class.equals(propertyType.getComponentType())) {
                result = new ArrayDomainCollector(propertyName);
            } else {
                String message = String.format("Can`t find domain for property \"%s\" of type \"%s\"", propertyName, propertyType.getSimpleName());
                OpenLMessagesUtils.addWarn((String)message);
            }
        }
        return result;
    }
}

