/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.openl.domain.EnumDomain;
import org.openl.domain.StringDomain;
import org.openl.rules.dt.type.domains.EnumDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainCollector;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;

public class StringDomainCollector
implements IDomainCollector {
    private String propertyToSearch;
    Set<String> stringProp = new HashSet<String>();

    public StringDomainCollector(String propertyToSearch) {
        this.propertyToSearch = propertyToSearch;
    }

    public void gatherDomains(TableSyntaxNode tsn) {
        String propvalue;
        ITableProperties tableProperties = tsn.getTableProperties();
        if (tableProperties != null && StringUtils.isNotEmpty((String)(propvalue = (String)tableProperties.getPropertyValue(this.propertyToSearch)))) {
            this.stringProp.add(propvalue);
        }
    }

    public IDomainAdaptor getGatheredDomain() {
        if (this.stringProp.isEmpty()) {
            this.stringProp.add("any");
        }
        StringDomain strDomain = new StringDomain(this.stringProp.toArray(new String[this.stringProp.size()]));
        return new EnumDomainAdaptor((EnumDomain<?>)strDomain);
    }
}

