/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.binding.ILocalVar;
import org.openl.domain.IDomain;
import org.openl.domain.IntRangeDomain;
import org.openl.domain.StringDomain;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.validator.ConditionAnalyzer;
import org.openl.rules.dt.validator.DecisionTableParamDescription;
import org.openl.rules.dt.validator.IDecisionTableValidatedObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.types.impl.ParameterDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableAnalyzer {
    private DecisionTable decisionTable;
    private Map<IDecisionRow, ConditionAnalyzer> conditionAnalyzers = new HashMap<IDecisionRow, ConditionAnalyzer>();
    private Map<String, DecisionTableParamDescription> usedParamsFromSignature = new HashMap<String, DecisionTableParamDescription>();

    public DecisionTableAnalyzer(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        this.init(decisionTable);
    }

    private void init(DecisionTable decisionTable) {
        ICondition[] conditionRows;
        for (ICondition conditionRow : conditionRows = decisionTable.getConditionRows()) {
            this.conditionAnalyzers.put(conditionRow, new ConditionAnalyzer(conditionRow));
        }
    }

    public boolean containsFormula(IDecisionRow row) {
        Object[][] paramValues = row.getParamValues();
        for (int i = 0; i < paramValues.length; ++i) {
            if (paramValues[i] == null) continue;
            for (Object paramValue : paramValues[i]) {
                if (!(paramValue instanceof IOpenMethod)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<DecisionTableParamDescription> tableParams() {
        return this.usedParamsFromSignature.values().iterator();
    }

    public DecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    public IDomain<?> getParameterDomain(String parameterName, IDecisionRow condition) {
        return this.conditionAnalyzers.get(condition).getParameterDomain(parameterName);
    }

    public IDomain<?> getSignatureParameterDomain(String parameterName) {
        return this.usedParamsFromSignature.get(parameterName).getDomain();
    }

    public IDomain<?> gatherDomainFromValues(IParameterDeclaration parameter, ICondition condition) {
        StringDomain result = null;
        Class type = parameter.getType().getInstanceClass();
        if (String.class.equals((Object)type)) {
            result = this.gatherStringDomainFromValues(condition.getParamValues());
        } else if (Integer.TYPE.equals(type)) {
            result = this.gatherIntDomainFromValues(condition.getParamValues());
        }
        return result;
    }

    private StringDomain gatherStringDomainFromValues(Object[][] values) {
        String[] enumValues = new String[values.length * values[0].length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            for (int j = 0; j < values[i].length; ++j) {
                enumValues[i * values[i].length + j] = (String)values[i][j];
            }
        }
        return new StringDomain(enumValues);
    }

    private IntRangeDomain gatherIntDomainFromValues(Object[][] values) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            for (int j = 0; j < values[i].length; ++j) {
                if (min > (Integer)values[i][j]) {
                    min = (Integer)values[i][j];
                }
                if (max >= (Integer)values[i][j]) continue;
                max = (Integer)values[i][j];
            }
        }
        return new IntRangeDomain(min, max);
    }

    public IParameterDeclaration[] referencedSignatureParams(IDecisionRow row) {
        CompositeMethod method = (CompositeMethod)row.getMethod();
        BindingDependencies bindingDependecies = new BindingDependencies();
        method.updateDependency(bindingDependecies);
        IMethodSignature methodSignature = this.decisionTable.getSignature();
        ArrayList<ParameterDeclaration> paramDeclarations = new ArrayList<ParameterDeclaration>();
        for (IOpenField openField : bindingDependecies.getFieldsMap().values()) {
            IOpenField anotherOpenField = this.getLocalField(openField);
            if (!(anotherOpenField instanceof ILocalVar)) continue;
            for (int i = 0; i < methodSignature.getNumberOfParameters(); ++i) {
                ParameterDeclaration parameterDeclaration;
                if (!methodSignature.getParameterName(i).equals(anotherOpenField.getName()) || paramDeclarations.contains(parameterDeclaration = new ParameterDeclaration(methodSignature.getParameterTypes()[i], methodSignature.getParameterName(i)))) continue;
                paramDeclarations.add(parameterDeclaration);
            }
        }
        return paramDeclarations.toArray(new IParameterDeclaration[paramDeclarations.size()]);
    }

    public IOpenClass transformSignatureType(IParameterDeclaration paramDeclarationFromSignature, IDecisionTableValidatedObject decisionTableToValidate) {
        DecisionTableParamDescription paramDescription = this.usedParamsFromSignature.get(paramDeclarationFromSignature.getName());
        if (paramDescription == null) {
            IOpenClass newType = decisionTableToValidate.getTransformer().transformSignatureType(paramDeclarationFromSignature);
            paramDescription = new DecisionTableParamDescription(paramDeclarationFromSignature, newType);
            this.usedParamsFromSignature.put(paramDeclarationFromSignature.getName(), paramDescription);
        }
        return paramDescription.getNewType();
    }

    public Map<String, DecisionTableParamDescription> getUsedParams() {
        return this.usedParamsFromSignature;
    }

    private IOpenField getLocalField(IOpenField field) {
        if (field instanceof ILocalVar) {
            return field;
        }
        if (field instanceof OpenFieldDelegator) {
            OpenFieldDelegator delegator = (OpenFieldDelegator)field;
            return delegator.getField();
        }
        return field;
    }
}

