/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.domain.IntRangeDomain;
import org.openl.exception.OpenLRuntimeException;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.IntBoolVar;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.domains.EnumDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IntRangeDomainAdaptor;
import org.openl.rules.dt.type.domains.JavaEnumDomainAdaptor;
import org.openl.rules.dt.validator.CtrIntRange;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableParamDescription;
import org.openl.rules.dt.validator.IConditionSelector;
import org.openl.rules.dt.validator.IConditionTransformer;
import org.openl.rules.dt.validator.IDecisionTableValidatedObject;
import org.openl.rules.helpers.IntRange;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaEnumDomain;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableValidatedObject
implements IDecisionTableValidatedObject,
IConditionTransformer {
    private DecisionTable decisionTable;
    private Map<String, IDomainAdaptor> domainMap;

    public DecisionTableValidatedObject(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
    }

    public DecisionTableValidatedObject(DecisionTable decisionTable, Map<String, IDomainAdaptor> domainMap) {
        this.decisionTable = decisionTable;
        this.domainMap = domainMap;
    }

    public synchronized Map<String, IDomainAdaptor> getDomains() {
        if (this.domainMap == null) {
            this.domainMap = this.makeDomains(this.decisionTable);
        }
        return this.domainMap;
    }

    @Override
    public DecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    @Override
    public IConditionSelector getSelector() {
        return null;
    }

    @Override
    public IConditionTransformer getTransformer() {
        return this;
    }

    private IDomainAdaptor makeDomainAdaptor(IDomain<?> domain) {
        IDomainAdaptor result = null;
        if (domain instanceof EnumDomain) {
            result = new EnumDomainAdaptor((EnumDomain)domain);
        } else if (domain instanceof IntRangeDomain) {
            IntRangeDomain irange = (IntRangeDomain)domain;
            result = new IntRangeDomainAdaptor(irange);
        } else if (domain instanceof JavaEnumDomain) {
            result = new JavaEnumDomainAdaptor((JavaEnumDomain)domain);
        }
        return result;
    }

    private Map<String, IDomainAdaptor> makeDomains(DecisionTable dt2) {
        return new HashMap<String, IDomainAdaptor>();
    }

    @Override
    public IntVar makeSignatureVar(String parameterName, IOpenClass paramType, Constrainer constrainer) {
        IDomainAdaptor domain = this.getDomains().get(parameterName);
        if (domain == null) {
            if (paramType.getDomain() != null) {
                domain = this.makeDomainAdaptor(paramType.getDomain());
            } else if (paramType.getInstanceClass() == Boolean.TYPE || paramType.getInstanceClass() == Boolean.class) {
                return constrainer.addIntBoolVar(parameterName);
            }
        }
        if (domain != null) {
            return constrainer.addIntVar(domain.getMin(), domain.getMax(), parameterName);
        }
        Log.warn((Object)("Parameter " + parameterName + " has no domain"));
        return null;
    }

    @Override
    public IOpenClass transformParameterType(IParameterDeclaration parameterDeclaration) {
        Class instanceClass = parameterDeclaration.getType().getInstanceClass();
        if (instanceClass == String.class || instanceClass == Date.class) {
            return JavaOpenClass.INT;
        }
        if (instanceClass == IntRange.class) {
            return JavaOpenClass.getOpenClass(CtrIntRange.class);
        }
        if (instanceClass == Boolean.TYPE || instanceClass == Boolean.class) {
            return JavaOpenClass.getOpenClass(IntBoolVar.class);
        }
        if (instanceClass.isEnum()) {
            return JavaOpenClass.INT;
        }
        return null;
    }

    @Override
    public Object transformLocalParameterValue(String name, ICondition condition, Object value, DecisionTableAnalyzer dtan) {
        IDomainAdaptor domainAdaptor;
        Object result = value;
        if (value instanceof IntRange) {
            IntRange intr = (IntRange)value;
            result = new CtrIntRange(intr.getMin(), intr.getMax());
        }
        if ((domainAdaptor = this.getDomains().get(name)) != null) {
            result = new Integer(domainAdaptor.getIndex(value));
        } else {
            IDomain<?> domain = dtan.getParameterDomain(name, condition);
            if (domain != null) {
                IDomainAdaptor domainAdapt = this.makeDomainAdaptor(domain);
                result = new Integer(domainAdapt.getIndex(value));
            } else if (!(value instanceof Integer)) {
                throw new OpenLRuntimeException(String.format("Could not create domain for %s", name));
            }
        }
        return result;
    }

    @Override
    public IOpenClass transformSignatureType(IParameterDeclaration parameterDeclaration) {
        Class instanceClass = parameterDeclaration.getType().getInstanceClass();
        if (instanceClass == String.class || instanceClass == Date.class) {
            return JavaOpenClass.getOpenClass(IntExp.class);
        }
        if (instanceClass == Integer.TYPE || instanceClass == Integer.class) {
            return JavaOpenClass.getOpenClass(IntExp.class);
        }
        if (instanceClass == Boolean.TYPE || instanceClass == Boolean.class) {
            return JavaOpenClass.getOpenClass(IntBoolVar.class);
        }
        if (instanceClass.isEnum()) {
            return JavaOpenClass.getOpenClass(IntExp.class);
        }
        return null;
    }

    @Override
    public Object transformSignatureValueBack(String name, int intValue, DecisionTableAnalyzer dtAnalyzer) {
        Object result = intValue;
        DecisionTableParamDescription pd = dtAnalyzer.getUsedParams().get(name);
        Class instanceClass = pd.getParameterDeclaration().getType().getInstanceClass();
        if (instanceClass == Boolean.TYPE || instanceClass == Boolean.class) {
            return intValue == 1 ? "true" : "false";
        }
        IDomainAdaptor domainAdapt = this.getDomains().get(name);
        if (domainAdapt != null) {
            result = domainAdapt.getValue(intValue);
        } else {
            IDomain<?> domain = dtAnalyzer.getSignatureParameterDomain(name);
            if (domain != null) {
                IDomainAdaptor domainAdaptor = this.makeDomainAdaptor(domain);
                result = domainAdaptor.getValue(intValue);
            } else {
                result = intValue;
            }
        }
        return result;
    }
}

