/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.Arrays;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.Uncovered;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableOverlapping;
import org.openl.rules.dt.validator.DecisionTableUncovered;
import org.openl.rules.dt.validator.IConditionTransformer;
import org.openl.rules.validator.IValidationResult;
import org.openl.util.ArrayOfNamedValues;

public class DesionTableValidationResult
implements IValidationResult {
    private DecisionTable decisionTable;
    private DecisionTableOverlapping[] overlappings;
    private DecisionTableUncovered[] uncovered;

    public DesionTableValidationResult(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
        this.overlappings = new DecisionTableOverlapping[0];
        this.uncovered = new DecisionTableUncovered[0];
    }

    public DesionTableValidationResult(DecisionTable decisionTable, Overlapping[] overlappings, Uncovered[] uncovered, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        this.decisionTable = decisionTable;
        this.overlappings = this.convertOverlappings(overlappings, transformer, analyzer);
        this.uncovered = this.convertUncovered(uncovered, transformer, analyzer);
    }

    private DecisionTableOverlapping[] convertOverlappings(Overlapping[] overlappings, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        DecisionTableOverlapping[] tableOverlappings = new DecisionTableOverlapping[overlappings.length];
        for (int i = 0; i < overlappings.length; ++i) {
            DecisionTableOverlapping tableOverlapping;
            String[] names = overlappings[i].getSolutionNames();
            Object[] values = new Object[names.length];
            for (int j = 0; j < values.length; ++j) {
                values[j] = transformer.transformSignatureValueBack(names[j], overlappings[i].getSolutionValues()[j], analyzer);
            }
            tableOverlappings[i] = tableOverlapping = new DecisionTableOverlapping(overlappings[i].getOverlapped(), new ArrayOfNamedValues(names, values));
        }
        return tableOverlappings;
    }

    private DecisionTableUncovered[] convertUncovered(Uncovered[] uncovered, IConditionTransformer transformer, DecisionTableAnalyzer analyzer) {
        DecisionTableUncovered[] tableUncovered = new DecisionTableUncovered[uncovered.length];
        for (int i = 0; i < uncovered.length; ++i) {
            String[] names = uncovered[i].getSolutionNames();
            Object[] values = new Object[names.length];
            for (int j = 0; j < values.length; ++j) {
                values[j] = transformer.transformSignatureValueBack(names[j], uncovered[i].getSolutionValues()[j], analyzer);
            }
            tableUncovered[i] = new DecisionTableUncovered(new ArrayOfNamedValues(names, values));
        }
        return tableUncovered;
    }

    public DecisionTable getDecisionTable() {
        return this.decisionTable;
    }

    public DecisionTableOverlapping[] getOverlappings() {
        return this.overlappings;
    }

    public DecisionTableUncovered[] getUncovered() {
        return this.uncovered;
    }

    public boolean hasProblems() {
        return this.overlappings != null && this.overlappings.length > 0 || this.uncovered != null && this.uncovered.length > 0;
    }

    public String toString() {
        StringBuffer validationResultDetails = new StringBuffer();
        if (this.getUncovered().length > 0) {
            validationResultDetails.append(String.format("There is an uncovered case for values: %s\r\n", Arrays.asList(this.getUncovered())));
        }
        if (this.getOverlappings().length > 0) {
            validationResultDetails.append(String.format("There is an overlap: %s", Arrays.asList(this.getOverlappings())));
        }
        return validationResultDetails.toString();
    }
}

