/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Pattern;
import org.openl.rules.helpers.IntRange;

public class CharRange
extends IntRange {
    private static Pattern p0 = Pattern.compile("\\S");
    private static Pattern p1 = Pattern.compile("\\S\\-\\S");
    private static Pattern p2 = Pattern.compile("\\S\\+");
    private static Pattern p3 = Pattern.compile("<\\S");

    public CharRange(char min, char max) {
        super(min, max);
    }

    public CharRange(char c) {
        super(Integer.valueOf(c));
    }

    public CharRange(String range) {
        super(0, 0);
        if (range == null) {
            throw new NullPointerException("CharRange value can not be null");
        }
        ParseStruct parsed = CharRange.parseRange(range);
        this.min = parsed.min;
        this.max = parsed.max;
    }

    private static ParseStruct parseRange(String range) {
        if (p1.matcher(range).matches()) {
            return new ParseStruct(range.charAt(0), range.charAt(2));
        }
        if (p2.matcher(range).matches()) {
            return new ParseStruct(range.charAt(0), '\uffff');
        }
        if (p3.matcher(range).matches()) {
            return new ParseStruct('\u0000', (char)(range.charAt(1) - '\u0001'));
        }
        if (p0.matcher(range).matches()) {
            return new ParseStruct(range.charAt(0), range.charAt(0));
        }
        throw new RuntimeException("Invalid Char Range: " + range);
    }

    public String toString() {
        return this.printChar(this.min) + "-" + this.printChar(this.max);
    }

    private String printChar(int ch) {
        return this.isPrintable(ch) ? String.valueOf((char)ch) : "'u" + Integer.toHexString(ch) + "'";
    }

    private boolean isPrintable(int ch) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return false;
        }
        if (ch < 255) {
            return true;
        }
        return Character.isUnicodeIdentifierPart(ch);
    }

    private static class ParseStruct {
        char min;
        char max;

        public ParseStruct(char min, char max) {
            this.min = min;
            this.max = max;
        }
    }
}

