/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.List;
import org.openl.OpenL;
import org.openl.domain.IntRangeDomain;
import org.openl.engine.OpenLManager;
import org.openl.message.OpenLMessages;
import org.openl.rules.helpers.INumberRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.util.RangeWithBounds;

public class IntRange
extends IntRangeDomain
implements INumberRange {
    public IntRange(int min, int max) {
        super(min, max);
        if (min > max) {
            throw new RuntimeException(max + " must be more or equal than " + min);
        }
    }

    public IntRange(Integer number) {
        super(number.intValue(), number.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntRange(String range) {
        super(0, 0);
        RangeWithBounds res;
        OpenL openl = OpenL.getInstance((String)"org.openl.j");
        List oldMessages = OpenLMessages.getCurrentInstance().getMessages();
        try {
            OpenLMessages.getCurrentInstance().clear();
            res = (RangeWithBounds)OpenLManager.run((OpenL)openl, (IOpenSourceCodeModule)new StringSourceCodeModule(range, ""), (SourceType)SourceType.INT_RANGE);
        }
        finally {
            OpenLMessages.getCurrentInstance().clear();
            OpenLMessages.getCurrentInstance().addMessages(oldMessages);
        }
        this.min = res.getMin().intValue();
        if (res.getLeftBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            ++this.min;
        }
        this.max = res.getMax().intValue();
        if (res.getRightBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            --this.max;
        }
    }
}

