/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

public class RoundingOperator {
    static final OpUp OP_UP = new OpUp();
    static final OpDown OP_DOWN = new OpDown();
    static final OpRound OP_ROUND = new OpRound();
    public static IRoundingOperator[] operators = new IRoundingOperator[]{OP_UP, OP_DOWN, OP_ROUND};
    IRoundingOperator operator;

    static IRoundingOperator findOperator(String op) {
        if (op == null) {
            throw new RuntimeException("RoundingOperator's name must not be null");
        }
        for (int i = 0; i < operators.length; ++i) {
            for (int j = 0; j < operators[i].getNames().length; ++j) {
                if (!operators[i].getNames()[j].equalsIgnoreCase(op)) continue;
                return operators[i];
            }
        }
        throw new RuntimeException("Unknown RoundingOperator name: " + op);
    }

    public RoundingOperator(String op) {
        this.operator = RoundingOperator.findOperator(op);
    }

    public double op(double value, double precision) {
        return this.operator.value(value, precision);
    }

    public String toString() {
        return this.operator.getNames()[0];
    }

    static class OpUp
    implements IRoundingOperator {
        OpUp() {
        }

        public String[] getNames() {
            return new String[]{"UP"};
        }

        public double value(double value, double precision) {
            return Math.ceil(value / precision) * precision;
        }
    }

    static class OpRound
    implements IRoundingOperator {
        OpRound() {
        }

        public String[] getNames() {
            return new String[]{"ROUND"};
        }

        public double value(double value, double precision) {
            return (double)Math.round(value / precision) * precision;
        }
    }

    static class OpDown
    implements IRoundingOperator {
        OpDown() {
        }

        public String[] getNames() {
            return new String[]{"DOWN"};
        }

        public double value(double value, double precision) {
            return Math.floor(value / precision) * precision;
        }
    }

    static interface IRoundingOperator {
        public String[] getNames();

        public double value(double var1, double var3);
    }
}

