/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import org.openl.rules.helpers.ITableAdaptor;
import org.openl.rules.table.IGridTable;

public class TablePrinter {
    public static String LEFT = "LEFT";
    public static String RIGHT = "RIGHT";
    String[] alignment;
    String separator;
    ITableAdaptor tableAdaptor;

    public static String printGridTable(IGridTable gridTable) {
        return new TablePrinter(new GridTableAdaptor(gridTable), null, " ! ").print();
    }

    public TablePrinter(String[][] data, String[] alignment, String separator) {
        this.tableAdaptor = new StringArrayTableAdator(data);
        this.alignment = alignment;
        this.separator = separator;
    }

    public TablePrinter(ITableAdaptor adaptor, String[] alignment, String separator) {
        this.tableAdaptor = adaptor;
        this.alignment = alignment;
        this.separator = separator;
    }

    int[] calcWidth(ITableAdaptor ta) {
        int[] width = new int[ta.maxWidth()];
        for (int i = 0; i < ta.height(); ++i) {
            if (ta.width(i) <= 1) continue;
            for (int j = 0; j < ta.width(i); ++j) {
                Object x = ta.get(j, i);
                if (x == null) continue;
                width[j] = Math.max(width[j], String.valueOf(x).length());
            }
        }
        return width;
    }

    public String print() {
        return this.print(0, this.tableAdaptor.height());
    }

    public String print(int from, int to) {
        StringBuffer sb = new StringBuffer();
        int[] width = this.calcWidth(this.tableAdaptor);
        for (int i = from; i < to; ++i) {
            for (int j = 0; j < this.tableAdaptor.width(i); ++j) {
                int k;
                String alignRow = LEFT;
                if (this.alignment != null && this.alignment[j] != null) {
                    alignRow = this.alignment[j];
                }
                if (j != 0) {
                    sb.append(this.separator);
                }
                Object obj = this.tableAdaptor.get(j, i);
                String cell = "";
                if (obj != null) {
                    cell = String.valueOf(obj);
                }
                if (LEFT.equals(alignRow)) {
                    sb.append(cell);
                    for (k = 0; k < width[j] - cell.length(); ++k) {
                        sb.append(' ');
                    }
                    continue;
                }
                if (!RIGHT.equals(alignRow)) continue;
                for (k = 0; k < width[j] - cell.length(); ++k) {
                    sb.append(' ');
                }
                sb.append(cell);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static class StringArrayTableAdator
    implements ITableAdaptor {
        String[][] array;

        StringArrayTableAdator(String[][] array) {
            this.array = array;
        }

        public Object get(int col, int row) {
            String[] r = this.array[row];
            return r == null || r.length <= col ? null : r[col];
        }

        public int height() {
            return this.array.length;
        }

        public int maxWidth() {
            int w = 0;
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == null) continue;
                w = Math.max(w, this.array[i].length);
            }
            return w;
        }

        public int width(int i) {
            return this.array[i].length;
        }
    }

    static class GridTableAdaptor
    implements ITableAdaptor {
        IGridTable table;

        public GridTableAdaptor(IGridTable gridTable) {
            this.table = gridTable;
        }

        public Object get(int col, int row) {
            return this.table.getCell(col, row).getStringValue();
        }

        public int height() {
            return this.table.getHeight();
        }

        public int maxWidth() {
            return this.table.getWidth();
        }

        public int width(int row) {
            return this.table.getWidth();
        }
    }
}

