/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers.scope;

import org.openl.OpenL;
import org.openl.base.NamedThing;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.meta.StringValue;
import org.openl.rules.helpers.scope.ScopeInstance;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.Log;
import org.openl.vm.IRuntimeEnv;

public class ScopeExpression
extends NamedThing {
    private static final Object NullObject = new Object();
    IOpenMethod method;
    StringValue expression;
    IOpenClass methodType = JavaOpenClass.STRING;
    String description;

    public String getDescription() {
        return this.description;
    }

    public StringValue getExpression() {
        return this.expression;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    protected String getMethodName() {
        return this.getName();
    }

    protected IOpenClass getMethodType() {
        return this.methodType;
    }

    public void makeMethod(ModuleOpenClass scope, IParameterDeclaration[] params) throws SyntaxNodeException {
        if (this.expression == null) {
            Log.warn((String)"{0} does not have an expression", (Object[])new Object[]{this.getName()});
            return;
        }
        MethodSignature signature = new MethodSignature(this.makeParams(params));
        OpenMethodHeader header = new OpenMethodHeader(this.getMethodName(), this.getMethodType(), (IMethodSignature)signature, (IOpenClass)scope);
        OpenL openl = scope.getOpenl();
        IBindingContext bcxt = openl.getBinder().makeBindingContext();
        ModuleBindingContext cxt = new ModuleBindingContext(bcxt, scope);
        CompositeMethod cm = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)this.expression.asSourceCodeModule(), (IOpenMethodHeader)header, (IBindingContext)cxt);
        IOpenClass type = cm.getMethodBodyBoundNode().getType();
        header.setTypeClass(type);
        this.method = cm;
    }

    protected IParameterDeclaration[] makeParams(IParameterDeclaration[] params) throws SyntaxNodeException {
        return params;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpression(StringValue sourceCode) {
        this.expression = sourceCode;
    }

    public void setMethod(IOpenMethod method) {
        this.method = method;
    }

    public void setMethodType(IOpenClass methodType) {
        this.methodType = methodType;
    }

    public void validatePostconditions() throws SyntaxNodeException {
    }

    public void validatePreconditions() throws SyntaxNodeException {
    }

    class ScopeField
    implements IOpenField {
        ScopeField() {
        }

        public synchronized Object get(Object target, IRuntimeEnv env) {
            ScopeInstance scopeInstance = (ScopeInstance)((Object)target);
            Object res = scopeInstance.getFieldValue(this.getName());
            if (res == null) {
                res = ScopeExpression.this.method.invoke(target, null, env);
                res = res == null ? NullObject : res;
                scopeInstance.setFieldValue(this.getName(), res);
            }
            return res == NullObject ? null : res;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public String getDisplayName(int mode) {
            return ScopeExpression.this.getDisplayName(mode);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public String getName() {
            return ScopeExpression.this.getName();
        }

        public IOpenClass getType() {
            return ScopeExpression.this.getMethodType();
        }

        public boolean isConst() {
            return true;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isWritable() {
            return true;
        }

        public void set(Object target, Object value, IRuntimeEnv env) {
            ((ScopeInstance)((Object)target)).setFieldValue(this.getName(), value);
        }
    }
}

