/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openl.rules.indexer.HitBucket;
import org.openl.rules.indexer.IIndexElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    static final String[] suffixes = new String[]{"ies", "es", "s", "ied", "ed", "id", "y"};
    static String[][] exceptions_array = new String[][]{{"s", "was", "whereas", "us"}, {"d", "word"}, {"es", "yes"}, {"id", "_id"}};
    private Map<String, TreeMap<String, TokenBucket>> firstCharMap = new TreeMap<String, TreeMap<String, TokenBucket>>();

    public static String getRoot(String token) {
        String lc;
        String result = lc = token.toLowerCase();
        int len = token.length();
        for (int i = 0; i < suffixes.length; ++i) {
            if (len <= suffixes[i].length() || !lc.endsWith(suffixes[i])) continue;
            result = lc.substring(0, len - suffixes[i].length());
        }
        return result;
    }

    static boolean isException(String suffix, String lc) {
        boolean result = false;
        for (int i = 0; i < exceptions_array.length; ++i) {
            if (!exceptions_array[i][0].equals(suffix)) continue;
            for (int j = 1; j < exceptions_array[i].length; ++j) {
                if (!lc.endsWith(exceptions_array[i][j])) continue;
                result = true;
            }
        }
        return result;
    }

    public void add(String token, IIndexElement element) {
        TokenBucket tb = this.findOrCreateTokenBucket(token);
        tb.addIndexElement(token, element);
    }

    public TokenBucket findOrCreateTokenBucket(String token) {
        String charStr = token.substring(0, 1).toUpperCase();
        Map<String, TokenBucket> charMap = this.getFirstCharMap(charStr);
        String tokenRoot = Index.getRoot(token);
        TokenBucket tb = this.getTokenBucket(charMap, tokenRoot);
        return tb;
    }

    public TokenBucket findEqualsTokenBucket(String token) {
        TokenBucket tokenBucket = null;
        String charStr = token.substring(0, 1).toUpperCase();
        Map charMap = this.firstCharMap.get(charStr);
        if (charMap != null) {
            String tokenRoot = Index.getRoot(token);
            tokenBucket = (TokenBucket)charMap.get(tokenRoot);
        }
        return tokenBucket;
    }

    public List<TokenBucket> findContainTokenBuckets(String token) {
        ArrayList<TokenBucket> tokBucks = new ArrayList<TokenBucket>();
        String charStr = token.substring(0, 1).toUpperCase();
        Map charMap = this.firstCharMap.get(charStr);
        if (charMap != null) {
            String tokenRoot = Index.getRoot(token);
            for (String keyValue : charMap.keySet()) {
                TokenBucket tokenBucket = null;
                if (!keyValue.contains(tokenRoot)) continue;
                tokenBucket = (TokenBucket)charMap.get(keyValue);
                tokBucks.add(tokenBucket);
            }
        }
        return tokBucks;
    }

    public Map<String, TreeMap<String, TokenBucket>> getFirstCharMap() {
        return this.firstCharMap;
    }

    protected synchronized Map<String, TokenBucket> getFirstCharMap(String charStr) {
        TreeMap<String, TokenBucket> map = this.firstCharMap.get(charStr);
        if (map == null) {
            map = new TreeMap();
            this.firstCharMap.put(charStr, map);
        }
        return map;
    }

    protected synchronized TokenBucket getTokenBucket(Map<String, TokenBucket> tokenMap, String token) {
        TokenBucket tb = tokenMap.get(token);
        if (tb == null) {
            tb = new TokenBucket(token);
            tokenMap.put(token, tb);
        }
        return tb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TokenBucket {
        public static final TokenComparator TOKEN_COMPARATOR = new TokenComparator();
        private String baseToken;
        private Map<String, HitBucket> indexElements = new HashMap<String, HitBucket>();
        private Set<String> tokens = new TreeSet<String>();

        TokenBucket(String token) {
            this.baseToken = token;
        }

        public void addIndexElement(String token, IIndexElement element) {
            this.tokens.add(token);
            this.getHitBucket(element).increment();
        }

        public String getDisplayValue() {
            return this.tokens.iterator().next();
        }

        public String getBaseToken() {
            return this.baseToken;
        }

        public synchronized HitBucket getHitBucket(IIndexElement element) {
            String uri = element.getUri();
            HitBucket hitBucket = this.indexElements.get(uri);
            if (hitBucket == null) {
                hitBucket = new HitBucket(element);
                this.indexElements.put(uri, hitBucket);
            }
            return hitBucket;
        }

        public Map<String, HitBucket> getIndexElements() {
            return this.indexElements;
        }

        public Set<String> getTokens() {
            return this.tokens;
        }

        public int size() {
            return this.indexElements.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TokenComparator
        implements Comparator<String> {
            TokenComparator() {
            }

            @Override
            public int compare(String s0, String s1) {
                return s0.length() == s1.length() ? s0.compareTo(s1) : s0.length() - s1.length();
            }
        }
    }
}

