/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openl.rules.indexer.HitBucket;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.indexer.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexQuery {
    private static final int ELEMENT_PRESENCE_WEIGHT = 20;
    private static final int CONTAINS_STR_WEIGHT = 100;
    private String[][] tokensInclude = null;
    protected String[][] tokensExclude = new String[0][];
    private IIndexElement[] indexExclude = new IIndexElement[0];
    private HashSet<IIndexElement> excludedIndexes;

    public static <K, V> Map<K, V> intersect(Map<K, V> m1, Map<K, V> m2) {
        HashMap<K, V> tm = new HashMap<K, V>();
        for (Map.Entry<K, V> element : m2.entrySet()) {
            if (!m1.containsKey(element.getKey())) continue;
            tm.put(element.getKey(), element.getValue());
        }
        return tm;
    }

    public IndexQuery(String[][] tokensInclude, String[][] tokensExclude, IIndexElement[] indexExclude) {
        this.tokensInclude = tokensInclude;
        if (tokensExclude != null) {
            this.tokensExclude = tokensExclude;
        }
        if (indexExclude != null) {
            this.indexExclude = indexExclude;
        }
    }

    private void makeExclusions(Index idx) {
        int i;
        this.excludedIndexes = new HashSet(this.indexExclude.length);
        for (i = 0; i < this.indexExclude.length; ++i) {
            this.excludedIndexes.add(this.indexExclude[i]);
        }
        for (i = 0; i < this.tokensExclude.length; ++i) {
            Map<String, HitBucket> exclusions = null;
            for (int j = 0; j < this.tokensExclude[i].length; ++j) {
                String tokenExclude = this.tokensExclude[i][j];
                Index.TokenBucket tb = idx.findEqualsTokenBucket(tokenExclude);
                if (tb == null) continue;
                exclusions = j == 0 ? tb.getIndexElements() : IndexQuery.intersect(exclusions, tb.getIndexElements());
            }
            if (exclusions == null) continue;
            for (HitBucket hb : exclusions.values()) {
                this.excludedIndexes.add(hb.getElement());
            }
        }
    }

    private Map<String, HitBucket> makeInclusions(Index idx) {
        HashMap<String, HitBucket> allInclusions = new HashMap<String, HitBucket>();
        for (int i = 0; i < this.tokensInclude.length; ++i) {
            Map<String, HitBucket> inclusions = this.makeInclusions(idx, this.tokensInclude[i]);
            for (HitBucket hb : inclusions.values()) {
                String uri = hb.getElement().getUri();
                HitBucket hbInc = (HitBucket)allInclusions.get(uri);
                if (hbInc == null) {
                    allInclusions.put(uri, hb);
                    continue;
                }
                hbInc.setWeight(hbInc.getWeight() * 20.0 * hb.getWeight());
            }
        }
        return allInclusions;
    }

    private Map<String, HitBucket> makeInclusions(Index idx, String[] tokens) {
        String searchStr = tokens[0];
        for (int i = 1; i < tokens.length; ++i) {
            searchStr = searchStr + " " + tokens[i];
        }
        searchStr = searchStr.toLowerCase();
        Map<String, HitBucket> inclusions = new HashMap<String, HitBucket>();
        if (this.isTokenQuery(tokens)) {
            for (int i = 0; i < tokens.length; ++i) {
                Index.TokenBucket equalTokBuck = idx.findEqualsTokenBucket(tokens[i]);
                if (equalTokBuck == null) {
                    List<Index.TokenBucket> containTokBucks = idx.findContainTokenBuckets(tokens[i]);
                    HashMap<String, HitBucket> containInclusions = new HashMap<String, HitBucket>();
                    for (Index.TokenBucket containTokBuck : containTokBucks) {
                        containInclusions.putAll(this.include(containTokBuck, i, searchStr, inclusions));
                    }
                    inclusions = containInclusions;
                    continue;
                }
                inclusions = this.include(equalTokBuck, i, searchStr, inclusions);
            }
        } else {
            Index.TokenBucket equalTokBuck = idx.findEqualsTokenBucket(searchStr);
            if (equalTokBuck == null) {
                List<Index.TokenBucket> containTokBucks = idx.findContainTokenBuckets(searchStr);
                Map<Object, Object> containInclusions = new HashMap();
                for (Index.TokenBucket containTokBuck : containTokBucks) {
                    containInclusions = this.includeSingleToken(containTokBuck, searchStr);
                    inclusions.putAll(containInclusions);
                }
            } else {
                inclusions = this.includeSingleToken(equalTokBuck, searchStr);
            }
        }
        return inclusions;
    }

    private boolean isTokenQuery(String[] tokens) {
        boolean result = false;
        if (tokens.length > 1) {
            result = true;
        }
        return result;
    }

    private Map<String, HitBucket> include(Index.TokenBucket tb, int i, String searchStr, Map<String, HitBucket> inclusions) {
        inclusions = i == 0 ? this.includeSingleToken(tb, searchStr) : this.filterQuery(tb, inclusions);
        return inclusions;
    }

    private Map<String, HitBucket> filterQuery(Index.TokenBucket tb, Map<String, HitBucket> inclusions) {
        HashMap<String, HitBucket> myInclusions = new HashMap<String, HitBucket>();
        for (HitBucket hb : tb.getIndexElements().values()) {
            String uri = hb.getElement().getUri();
            HitBucket hbInc = inclusions.get(uri);
            if (hbInc == null) continue;
            hbInc.setWeight(hb.getWeight() + hbInc.getWeight());
            myInclusions.put(uri, hbInc);
        }
        return myInclusions;
    }

    private Map<String, HitBucket> includeSingleToken(Index.TokenBucket tb, String searchStr) {
        HashMap<String, HitBucket> inclusions = new HashMap<String, HitBucket>();
        for (HitBucket hb : tb.getIndexElements().values()) {
            boolean contains;
            if (this.excludedIndexes.contains(hb.getElement())) continue;
            HitBucket hbInc = new HitBucket(hb);
            boolean bl = contains = hbInc.getElement().getIndexedText().toLowerCase().indexOf(searchStr) >= 0;
            if (contains) {
                hbInc.setWeight(hbInc.getWeight() * 100.0);
            }
            inclusions.put(hb.getElement().getUri(), hbInc);
        }
        return inclusions;
    }

    public String[][] getTokensInclude() {
        return this.tokensInclude;
    }

    public void setTokensExclude(String[][] tokensExclude) {
        this.tokensExclude = tokensExclude;
    }

    public void setIndexExclude(IIndexElement[] indexExclude) {
        this.indexExclude = indexExclude;
    }

    public TreeSet<HitBucket> executeSearch(Index idx) {
        TreeSet<HitBucket> result = new TreeSet<HitBucket>();
        this.makeExclusions(idx);
        Map<String, HitBucket> allInc = this.makeInclusions(idx);
        for (HitBucket hb : allInc.values()) {
            result.add(hb);
        }
        return result;
    }
}

