/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.indexer.IndexQuery;

public class IndexQueryParser {
    private List<String[]> included = new ArrayList<String[]>();
    private List<String[]> excluded = new ArrayList<String[]>();
    private String input;
    private String[] tokens = new String[100];
    private int nTokens = 0;
    private int startPos = 0;
    private boolean wordStarted = false;
    private boolean openBracket = false;
    private boolean letter = false;
    private boolean space = false;
    private boolean bracket = false;
    private int pos = 0;

    private IndexQueryParser(String input) {
        this.input = input;
    }

    private void closeToken() {
        if (this.wordStarted) {
            this.tokens[this.nTokens++] = this.input.substring(this.startPos, this.pos);
            this.wordStarted = false;
        }
    }

    private void flushTokens() {
        if (this.nTokens != 0) {
            String[] newtokens = new String[this.nTokens];
            for (int i = 0; i < this.nTokens; ++i) {
                newtokens[i] = this.tokens[i];
            }
            this.included.add(newtokens);
            this.wordStarted = false;
            this.openBracket = false;
            this.nTokens = 0;
        }
    }

    private void newToken() {
        this.startPos = this.pos;
        this.wordStarted = true;
    }

    public static IndexQuery parse(String strInput) {
        IndexQueryParser iqp = new IndexQueryParser(strInput);
        IndexQuery iq = iqp.parse();
        return iq;
    }

    private IndexQuery parse() {
        while (this.pos < this.input.length()) {
            this.bracket = false;
            this.space = false;
            this.letter = false;
            char charAtPos = this.input.charAt(this.pos);
            if (charAtPos == '\"') {
                this.bracket = true;
            } else if (charAtPos == ' ') {
                this.space = true;
            } else {
                this.letter = true;
            }
            if (!this.wordStarted && this.letter) {
                this.newToken();
            } else if (!this.openBracket && this.wordStarted && this.space) {
                this.closeToken();
                this.flushTokens();
            } else if (this.openBracket && this.wordStarted && this.space) {
                this.closeToken();
            } else if (!this.openBracket && this.bracket) {
                this.closeToken();
                this.flushTokens();
                this.openBracket = true;
            } else if (this.openBracket && this.bracket) {
                this.closeToken();
                this.flushTokens();
                this.openBracket = false;
            }
            ++this.pos;
        }
        this.closeToken();
        this.flushTokens();
        IndexQuery iq = new IndexQuery((String[][])this.included.toArray((T[])new String[0][]), (String[][])this.excluded.toArray((T[])new String[0][]), null);
        return iq;
    }
}

