/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import org.openl.rules.indexer.DefaultIndexer;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.indexer.IIndexParser;
import org.openl.rules.indexer.IIndexer;
import org.openl.rules.indexer.Index;

public class IndexRunner {
    private IIndexer[] indexers;
    protected IIndexer defaultIndexer = new DefaultIndexer();
    private IIndexParser[] parsers;

    public IndexRunner(IIndexParser[] parsers, IIndexer[] indexers, IIndexer defaultIndexer) {
        this.parsers = parsers;
        this.indexers = indexers;
        this.defaultIndexer = defaultIndexer;
    }

    private IIndexer findIndexer(IIndexElement element) {
        int i;
        for (i = 0; i < this.indexers.length; ++i) {
            if (!this.indexers[i].getType().equals(element.getType()) || !this.indexers[i].getCategory().equals(element.getCategory())) continue;
            return this.indexers[i];
        }
        for (i = 0; i < this.indexers.length; ++i) {
            if (!this.indexers[i].getCategory().equals(element.getCategory())) continue;
            return this.indexers[i];
        }
        return this.defaultIndexer;
    }

    private IIndexParser findParser(IIndexElement element) {
        int i;
        for (i = 0; i < this.parsers.length; ++i) {
            if (!this.parsers[i].getType().equals(element.getType()) || !this.parsers[i].getCategory().equals(element.getCategory())) continue;
            return this.parsers[i];
        }
        for (i = 0; i < this.parsers.length; ++i) {
            if (!this.parsers[i].getCategory().equals(element.getCategory())) continue;
            return this.parsers[i];
        }
        return null;
    }

    public void index(IIndexElement element, Index index) {
        IIndexParser parser = this.findParser(element);
        IIndexer indexer = this.findIndexer(element);
        if (indexer != null) {
            indexer.index(element, index);
        }
        if (parser != null) {
            IIndexElement[] elements = parser.parse(element);
            for (int i = 0; i < elements.length; ++i) {
                this.index(elements[i], index);
            }
        }
    }
}

