/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.indexer.IIndexParser;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableIndexParser
implements IIndexParser {
    private static final Log LOG = LogFactory.getLog(TableIndexParser.class);

    @Override
    public String getCategory() {
        return IDocumentType.WORKSHEET_TABLE.getCategory();
    }

    @Override
    public String getType() {
        return "All";
    }

    @Override
    public IIndexElement[] parse(IIndexElement root) {
        TableSyntaxNode tableSrc = (TableSyntaxNode)root;
        IGridTable table = tableSrc.getGridTable();
        int w = table.getWidth();
        int h = table.getHeight();
        ArrayList<GridCellSourceCodeModule> gridCells = new ArrayList<GridCellSourceCodeModule>();
        HashMap<String, IGridRegion> processedValuesFromRegions = new HashMap<String, IGridRegion>();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                String cellValue = null;
                ICell cell = null;
                try {
                    cell = table.getCell(j, i);
                    cellValue = cell.getStringValue();
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)("There is an error in cell in table:[" + tableSrc.getDisplayName() + "]"), (Throwable)e);
                }
                if (cellValue == null || this.isCellBelongingToProcessedRegion(cell, cellValue, processedValuesFromRegions)) continue;
                if (this.isCellFromMergedRegion(cell)) {
                    processedValuesFromRegions.put(cellValue, cell.getRegion());
                }
                gridCells.add(new GridCellSourceCodeModule(table, j, i, null));
            }
        }
        return gridCells.toArray(new GridCellSourceCodeModule[gridCells.size()]);
    }

    private boolean isCellFromMergedRegion(ICell cell) {
        return cell.getRegion() != null;
    }

    private boolean isCellBelongingToProcessedRegion(ICell cell, String cellValue, Map<String, IGridRegion> processedValuesFromRegions) {
        boolean cellBelongsToProssedRegion = false;
        if (this.isCellFromMergedRegion(cell) && processedValuesFromRegions.containsKey(cellValue)) {
            cellBelongsToProssedRegion = IGridRegion.Tool.contains(processedValuesFromRegions.get(cellValue), cell.getAbsoluteColumn(), cell.getAbsoluteRow());
        }
        return cellBelongsToProssedRegion;
    }
}

