/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import java.util.ArrayList;

public class Tokenizer {
    private Tokenizer() {
    }

    private static String getAlphanumericToken(String textToTokenize, int startPos) {
        char c;
        int pos;
        for (pos = startPos + 1; pos < textToTokenize.length() && (Character.isLetterOrDigit(c = textToTokenize.charAt(pos)) || c == '_' || c == '#' || c == '&'); ++pos) {
        }
        return textToTokenize.substring(startPos, pos);
    }

    private static String getNumberToken(String textToTokenize, int startPos) {
        char c;
        int pos;
        for (pos = startPos + 1; pos < textToTokenize.length() && (Character.isDigit(c = textToTokenize.charAt(pos)) || c == '.' || c == '%'); ++pos) {
        }
        return textToTokenize.substring(startPos, pos);
    }

    public static String[] parse(String textToTokenize) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(textToTokenize);
        if (Tokenizer.textIsComposite(textToTokenize)) {
            tokens.add(textToTokenize);
        }
        for (int pos = 0; pos < textToTokenize.length(); ++pos) {
            char currentSymbol = textToTokenize.charAt(pos);
            String currentToken = null;
            if (Character.isLetter(currentSymbol)) {
                currentToken = Tokenizer.getAlphanumericToken(textToTokenize, pos);
            } else if (Character.isDigit(currentSymbol)) {
                currentToken = Tokenizer.getNumberToken(textToTokenize, pos);
            }
            if (currentToken == null) continue;
            tokens.add(currentToken);
            pos += currentToken.length();
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean textIsComposite(String textToTokenize) {
        boolean result = false;
        for (int pos = 0; pos < textToTokenize.length(); ++pos) {
            int indexOfDash = textToTokenize.indexOf(45, pos);
            if (indexOfDash <= 0) continue;
            char charBeforeDash = textToTokenize.charAt(indexOfDash - 1);
            if (indexOfDash + 1 >= textToTokenize.length()) continue;
            char charAfterDash = textToTokenize.charAt(indexOfDash + 1);
            if (!Character.isLetter(charBeforeDash) || !Character.isLetter(charAfterDash)) continue;
            result = true;
            pos = indexOfDash + 1;
        }
        return result;
    }
}

