/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.word.WordDocSourceCodeModule;

public class WordParagraphElement
implements IIndexElement {
    Paragraph paragraph;
    int paragraphNum;
    WordDocSourceCodeModule document;
    String indexedText = null;
    String uri;

    public WordParagraphElement(Paragraph paragraph, int paragraphNum, WordDocSourceCodeModule document) {
        this.paragraph = paragraph;
        this.paragraphNum = paragraphNum;
        this.document = document;
    }

    public String getCategory() {
        return IDocumentType.WORD_PARAGRAPH.getCategory();
    }

    public String getDisplayName() {
        return null;
    }

    public WordDocSourceCodeModule getDocument() {
        return this.document;
    }

    public String getIndexedText() {
        if (this.indexedText != null) {
            return this.indexedText;
        }
        this.indexedText = this.paragraph.getCharacterRun(0).text();
        for (int i = 1; i < this.paragraph.numCharacterRuns(); ++i) {
            CharacterRun chr = this.paragraph.getCharacterRun(i);
            this.indexedText = this.indexedText + chr.text();
        }
        return this.indexedText;
    }

    public Paragraph getParagraph() {
        return this.paragraph;
    }

    public int getParagraphNum() {
        return this.paragraphNum;
    }

    public String getType() {
        return IDocumentType.WORD_PARAGRAPH.getType();
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = this.document.getUri() + "?" + "wdParStart" + "=" + this.paragraphNum + "&" + "wdParEnd" + "=" + this.paragraphNum;
        }
        return this.uri;
    }
}

