/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.RangeHack;
import org.apache.poi.hwpf.usermodel.Table;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.word.WordDocSourceCodeModule;

public class WordTableElement
implements IIndexElement {
    Table table;
    WordDocSourceCodeModule document;
    String uri;

    public WordTableElement(Table table, WordDocSourceCodeModule document) {
        this.table = table;
        this.document = document;
    }

    public String getCategory() {
        return IDocumentType.WORD_TABLE.getCategory();
    }

    public String getDisplayName() {
        return null;
    }

    public WordDocSourceCodeModule getDocument() {
        return this.document;
    }

    public String getIndexedText() {
        return null;
    }

    public int getParagraphNum() {
        return RangeHack.getParStart((Range)this.table) + 1;
    }

    public Table getTable() {
        return this.table;
    }

    public String getType() {
        return IDocumentType.WORD_TABLE.getType();
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = this.document.getUri() + "?" + "wdParStart" + "=" + this.getParagraphNum() + '&' + "wdParEnd" + '=' + (this.getParagraphNum() + this.table.numParagraphs() - 1);
        }
        return this.uri;
    }
}

