/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.indexer;

import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.indexer.IIndexParser;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;

public class WorksheetIndexParser
implements IIndexParser {
    private static final String NOT_AVAILABLE = "N/A";

    public String getCategory() {
        return IDocumentType.WORKSHEET.getCategory();
    }

    public String getType() {
        return IDocumentType.WORKSHEET.getType();
    }

    public IIndexElement[] parse(IIndexElement root) {
        XlsSheetSourceCodeModule sheetSrc = (XlsSheetSourceCodeModule)root;
        return this.parseSheet(sheetSrc);
    }

    public TableSyntaxNode[] parseSheet(XlsSheetSourceCodeModule sheetSrc) {
        XlsSheetGridModel xlsGrid = new XlsSheetGridModel(sheetSrc);
        IGridTable[] tables = xlsGrid.getTables();
        TableSyntaxNode[] nodes = new TableSyntaxNode[tables.length];
        for (int i = 0; i < nodes.length; ++i) {
            IdentifierNode parsedHeader;
            IGridTable table = tables[i];
            GridCellSourceCodeModule src = new GridCellSourceCodeModule(table);
            try {
                parsedHeader = Tokenizer.firstToken((IOpenSourceCodeModule)src, (String)" \n\r");
            }
            catch (OpenLCompilationException e) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse table header", (Throwable)e, null, (IOpenSourceCodeModule)src);
                OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
                continue;
            }
            HeaderSyntaxNode headerNode = new HeaderSyntaxNode(src, parsedHeader);
            String header = parsedHeader.getIdentifier();
            String xls_type = XlsLoader.getTableHeaders().get(header);
            if (xls_type == null) {
                xls_type = NOT_AVAILABLE;
            }
            nodes[i] = new TableSyntaxNode(xls_type, new GridLocation(table), sheetSrc, table, headerNode);
        }
        return nodes;
    }
}

