/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BoundCode;
import org.openl.binding.impl.module.ModuleNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.conf.IExecutable;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenLBuilderImpl;
import org.openl.meta.IVocabulary;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.SpreadsheetNodeBinder;
import org.openl.rules.cmatch.ColumnMatchNodeBinder;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DatatypeNodeBinder;
import org.openl.rules.dt.DecisionTableNodeBinder;
import org.openl.rules.extension.bind.IExtensionBinder;
import org.openl.rules.extension.bind.NameConventionBinderFactory;
import org.openl.rules.lang.xls.SyntaxNodeConvertor;
import org.openl.rules.lang.xls.TableSyntaxNodeComparator;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.MethodTableNodeBinder;
import org.openl.rules.property.PropertyTableBinder;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.tbasic.AlgorithmNodeBinder;
import org.openl.rules.testmethod.TestMethodNodeBinder;
import org.openl.rules.validation.properties.dimentional.DispatcherTableBuilder;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.util.ASelector;
import org.openl.util.AStringConvertor;
import org.openl.util.ISelector;
import org.openl.util.RuntimeExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsBinder
implements IOpenBinder {
    private static final Log LOG = LogFactory.getLog(XlsBinder.class);
    private static Map<String, AXlsTableBinder> binderFactory;
    private static final String[][] binders;
    private IUserContext userContext;

    public static synchronized Map<String, AXlsTableBinder> getBinderFactory() {
        if (binderFactory == null) {
            binderFactory = new HashMap<String, AXlsTableBinder>();
            for (int i = 0; i < binders.length; ++i) {
                try {
                    binderFactory.put(binders[i][0], (AXlsTableBinder)((Object)Class.forName(binders[i][1]).newInstance()));
                    continue;
                }
                catch (Exception ex) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)ex);
                }
            }
        }
        return binderFactory;
    }

    public XlsBinder(IUserContext userContext) {
        this.userContext = userContext;
    }

    public ICastFactory getCastFactory() {
        return null;
    }

    public INameSpacedMethodFactory getMethodFactory() {
        return null;
    }

    public INodeBinderFactory getNodeBinderFactory() {
        return null;
    }

    public INameSpacedTypeFactory getTypeFactory() {
        return null;
    }

    public INameSpacedVarFactory getVarFactory() {
        return null;
    }

    public IBindingContext makeBindingContext() {
        throw new UnsupportedOperationException("XlsBinder is top level Binder");
    }

    public IBoundCode bind(IParsedCode parsedCode) {
        return this.bind(parsedCode, null);
    }

    public IBoundCode bind(IParsedCode parsedCode, IBindingContextDelegator bindingContextDelegator) {
        XlsModuleSyntaxNode moduleNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
        OpenL openl = null;
        try {
            openl = this.makeOpenL(moduleNode);
        }
        catch (OpenConfigurationException ex) {
            OpenlSyntaxNode syntaxNode = moduleNode.getOpenlNode();
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Error Creating OpenL", (Throwable)ex, (ISyntaxNode)syntaxNode);
            BindHelper.processError((SyntaxNodeException)error);
            return BindHelper.makeInvalidCode((IParsedCode)parsedCode, (ISyntaxNode)syntaxNode, (SyntaxNodeException[])new SyntaxNodeException[]{error});
        }
        IOpenBinder openlBinder = openl.getBinder();
        IBindingContext bindingContext = openlBinder.makeBindingContext();
        bindingContext = BindHelper.delegateContext((IBindingContext)bindingContext, (IBindingContextDelegator)bindingContextDelegator);
        if (parsedCode.getExternalParams() != null) {
            bindingContext.setExternalParams(parsedCode.getExternalParams());
        }
        IBoundNode topNode = this.bind(moduleNode, openl, bindingContext);
        return new BoundCode(parsedCode, topNode, bindingContext.getErrors(), 0);
    }

    public IBoundNode bind(XlsModuleSyntaxNode moduleNode, OpenL openl, IBindingContext bindingContext) {
        XlsModuleOpenClass module = new XlsModuleOpenClass(null, XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl);
        this.processExtensions(module, moduleNode, moduleNode.getExtensionNodes());
        RulesModuleBindingContext moduleContext = new RulesModuleBindingContext(bindingContext, module);
        IVocabulary vocabulary = this.makeVocabulary(moduleNode);
        if (vocabulary != null) {
            this.processVocabulary(vocabulary, bindingContext, moduleContext);
        }
        ASelector.StringValueSelector propertiesSelector = new ASelector.StringValueSelector(XlsNodeTypes.XLS_PROPERTIES.toString(), (AStringConvertor)new SyntaxNodeConvertor());
        TableSyntaxNode[] propertyNodes = this.getTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)propertiesSelector, null);
        this.bindInternal(moduleNode, module, propertyNodes, openl, moduleContext);
        this.bindPropertiesForAllTables(moduleNode, module, openl, moduleContext);
        ASelector.StringValueSelector dataTypeSelector = new ASelector.StringValueSelector(XlsNodeTypes.XLS_DATATYPE.toString(), (AStringConvertor)new SyntaxNodeConvertor());
        TableSyntaxNode[] datatypeNodes = this.getTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)dataTypeSelector, null);
        TableSyntaxNode[] processedDatatypeNodes = this.processDatatypes(datatypeNodes, (IBindingContext)moduleContext);
        this.bindInternal(moduleNode, module, processedDatatypeNodes, openl, moduleContext);
        ISelector notPropertiesSelector = propertiesSelector.not();
        ISelector notDataTypeSelector = dataTypeSelector.not();
        ISelector notProp_And_NotDatatypeSelectors = notDataTypeSelector.and(notPropertiesSelector);
        TableSyntaxNodeComparator tableComparator = new TableSyntaxNodeComparator();
        TableSyntaxNode[] otherNodes = this.getTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)notProp_And_NotDatatypeSelectors, tableComparator);
        IBoundNode topNode = this.bindInternal(moduleNode, module, otherNodes, openl, moduleContext);
        DispatcherTableBuilder dispTableBuilder = new DispatcherTableBuilder(openl, (XlsModuleOpenClass)topNode.getType(), moduleContext);
        dispTableBuilder.buildDispatcherTables();
        return topNode;
    }

    private void bindPropertiesForAllTables(XlsModuleSyntaxNode moduleNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext bindingContext) {
        ASelector.StringValueSelector dataTypeSelector = new ASelector.StringValueSelector(XlsNodeTypes.XLS_PROPERTIES.toString(), (AStringConvertor)new SyntaxNodeConvertor());
        ASelector.StringValueSelector otherNodesSelector = new ASelector.StringValueSelector(XlsNodeTypes.XLS_OTHER.toString(), (AStringConvertor)new SyntaxNodeConvertor());
        ISelector notDataType_and_notOther_NodesSelector = dataTypeSelector.not().and(otherNodesSelector.not());
        TableSyntaxNode[] tableSyntaxNodes = this.getTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)notDataType_and_notOther_NodesSelector, null);
        PropertiesLoader propLoader = new PropertiesLoader(openl, bindingContext, module);
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            try {
                propLoader.loadProperties(tsn);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tsn, bindingContext);
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tsn, bindingContext);
                }
            }
            catch (Throwable t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.processError(error, tsn, bindingContext);
            }
        }
    }

    private TableSyntaxNode[] processDatatypes(TableSyntaxNode[] datatypeNodes, IBindingContext bindingContext) {
        Map<String, TableSyntaxNode> typesMap = DatatypeHelper.createTypesMap(datatypeNodes, bindingContext);
        TableSyntaxNode[] orderedTypes = DatatypeHelper.orderDatatypes(typesMap, bindingContext);
        return orderedTypes;
    }

    private void processVocabulary(IVocabulary vocabulary, IBindingContext bindingContext, RulesModuleBindingContext moduleContext) {
        IOpenClass[] types = null;
        try {
            types = vocabulary.getVocabularyTypes();
        }
        catch (SyntaxNodeException error) {
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)bindingContext);
        }
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                try {
                    moduleContext.addType("org.openl.this", types[i]);
                    continue;
                }
                catch (Throwable t) {
                    BindHelper.processError(null, (Throwable)t, (IBindingContext)bindingContext);
                }
            }
        }
    }

    private void processExtensions(XlsModuleOpenClass module, XlsModuleSyntaxNode moduleNode, List<IdentifierNode> extensionNodes) {
        for (int i = 0; i < extensionNodes.size(); ++i) {
            IdentifierNode identifierNode = extensionNodes.get(i);
            IExtensionBinder binder = NameConventionBinderFactory.INSTANCE.getNodeBinder(identifierNode);
            if (binder == null || !binder.getNodeType().equals(identifierNode.getType())) continue;
            binder.bind(module, moduleNode, identifierNode);
        }
    }

    private OpenL makeOpenL(XlsModuleSyntaxNode moduleNode) {
        String openlName = this.getOpenLName(moduleNode.getOpenlNode());
        List<String> allImports = moduleNode.getAllImports();
        if (allImports == null) {
            return OpenL.getInstance((String)openlName, (IUserContext)this.userContext);
        }
        OpenLBuilderImpl builder = new OpenLBuilderImpl();
        builder.setExtendsCategory(openlName);
        String category = openlName + "::" + moduleNode.getModule().getUri(0);
        builder.setCategory(category);
        builder.setImports(allImports);
        builder.setContexts(null, this.userContext);
        builder.setInheritExtendedConfigurationLoader(true);
        return OpenL.getInstance((String)category, (IUserContext)this.userContext, (IOpenLBuilder)builder);
    }

    private IVocabulary makeVocabulary(XlsModuleSyntaxNode moduleNode) {
        final IdentifierNode vocabularyNode = moduleNode.getVocabularyNode();
        if (vocabularyNode == null) {
            return null;
        }
        final ClassLoader userClassLoader = this.userContext.getUserClassLoader();
        Thread.currentThread().setContextClassLoader(userClassLoader);
        IVocabulary vocabulary = (IVocabulary)this.userContext.execute(new IExecutable(){

            public Object execute() {
                String vocabularyClassName = vocabularyNode.getIdentifier();
                try {
                    Class<?> vClass = userClassLoader.loadClass(vocabularyClassName);
                    return (IVocabulary)vClass.newInstance();
                }
                catch (Throwable t) {
                    String message = String.format("Vocabulary type '%s' cannot be loaded", vocabularyClassName);
                    BindHelper.processError((String)message, (ISyntaxNode)vocabularyNode, (Throwable)t);
                    return null;
                }
            }
        });
        return vocabulary;
    }

    private IMemberBoundNode preBindXlsNode(ISyntaxNode syntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass moduleOpenClass) throws Exception {
        String type = syntaxNode.getType();
        AXlsTableBinder binder = XlsBinder.getBinderFactory().get(type);
        if (binder == null) {
            String message = String.format("Unknown table type '%s'", type);
            LOG.debug((Object)message);
            return null;
        }
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)syntaxNode;
        return binder.preBind(tableSyntaxNode, openl, (IBindingContext)bindingContext, moduleOpenClass);
    }

    private String getOpenLName(OpenlSyntaxNode osn) {
        return osn == null ? "org.openl.rules.java" : osn.getOpenlName();
    }

    private TableSyntaxNode[] getTableSyntaxNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector, Comparator<TableSyntaxNode> tableComparator) {
        ArrayList<TableSyntaxNode> childSyntaxNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : moduleSyntaxNode.getXlsTableSyntaxNodes()) {
            if (childSelector != null && !childSelector.select((Object)tsn)) continue;
            childSyntaxNodes.add(tsn);
        }
        TableSyntaxNode[] tableSyntaxNodes = childSyntaxNodes.toArray(new TableSyntaxNode[childSyntaxNodes.size()]);
        if (tableComparator != null) {
            try {
                Arrays.sort(tableSyntaxNodes, tableComparator);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return tableSyntaxNodes;
    }

    private IBoundNode bindInternal(XlsModuleSyntaxNode moduleSyntaxNode, XlsModuleOpenClass module, TableSyntaxNode[] tableSyntaxNodes, OpenL openl, RulesModuleBindingContext moduleContext) {
        int i;
        IMemberBoundNode[] children = new IMemberBoundNode[tableSyntaxNodes.length];
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            IMemberBoundNode child;
            children[i] = child = this.beginBind(tableSyntaxNodes[i], module, openl, moduleContext);
            if (child == null) continue;
            child.addTo((ModuleOpenClass)module);
        }
        for (i = 0; i < children.length; ++i) {
            if (children[i] == null) continue;
            this.finilizeBind(children[i], tableSyntaxNodes[i], moduleContext);
        }
        return new ModuleNode((ISyntaxNode)moduleSyntaxNode, (IOpenClass)moduleContext.getModule());
    }

    private void finilizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        try {
            memberBoundNode.finalizeBind((IBindingContext)moduleContext);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
        }
        catch (CompositeSyntaxNodeException ex) {
            for (SyntaxNodeException error : ex.getErrors()) {
                this.processError(error, tableSyntaxNode, moduleContext);
            }
        }
        catch (Throwable t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
        }
    }

    private IMemberBoundNode beginBind(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext moduleContext) {
        try {
            return this.preBindXlsNode((ISyntaxNode)tableSyntaxNode, openl, moduleContext, module);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
        catch (CompositeSyntaxNodeException ex) {
            for (SyntaxNodeException error : ex.getErrors()) {
                this.processError(error, tableSyntaxNode, moduleContext);
            }
            return null;
        }
        catch (Throwable t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
    }

    private void processError(SyntaxNodeException error, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        error.setTopLevelSyntaxNode((ISyntaxNode)tableSyntaxNode);
        tableSyntaxNode.addError(error);
        BindHelper.processError((SyntaxNodeException)error, (IBindingContext)moduleContext);
    }

    static {
        binders = new String[][]{{XlsNodeTypes.XLS_DATA.toString(), DataNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DATATYPE.toString(), DatatypeNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DT.toString(), DecisionTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_SPREADSHEET.toString(), SpreadsheetNodeBinder.class.getName()}, {XlsNodeTypes.XLS_METHOD.toString(), MethodTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TEST_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_RUN_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TBASIC.toString(), AlgorithmNodeBinder.class.getName()}, {XlsNodeTypes.XLS_COLUMN_MATCH.toString(), ColumnMatchNodeBinder.class.getName()}, {XlsNodeTypes.XLS_PROPERTIES.toString(), PropertyTableBinder.class.getName()}};
    }
}

