/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.net.MalformedURLException;
import java.net.URL;
import org.openl.binding.IBoundCode;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.rules.lang.xls.XlsBinder;
import org.openl.rules.lang.xls.XlsParser;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.IOpenClass;
import org.openl.util.Log;
import org.openl.util.PropertiesLocator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;

public abstract class XlsHelper {
    public static XlsMetaInfo getXlsMetaInfo(String srcFile) {
        UserContext ucxt = new UserContext(Thread.currentThread().getContextClassLoader(), ".");
        String fileOrURL = PropertiesLocator.locateFileOrURL((String)srcFile, (ClassLoader)ucxt.getUserClassLoader(), (String[])new String[]{ucxt.getUserHome()});
        if (fileOrURL == null) {
            throw new RuntimeException("File " + srcFile + " is not found");
        }
        Object src = null;
        try {
            src = fileOrURL.indexOf(58) < 2 ? new FileSourceCodeModule(fileOrURL, null) : new URLSourceCodeModule(new URL(fileOrURL));
        }
        catch (MalformedURLException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        IParsedCode pc = new XlsParser((IUserContext)ucxt).parseAsModule((IOpenSourceCodeModule)src);
        IBoundCode bc = new XlsBinder((IUserContext)ucxt).bind(pc);
        IOpenClass ioc = bc.getTopNode().getType();
        return (XlsMetaInfo)ioc.getMetaInfo();
    }

    public static String getModuleName(XlsModuleSyntaxNode node) {
        String uri = node.getModule().getUri(0);
        try {
            URL url = new URL(uri);
            String file = url.getFile();
            int index = file.lastIndexOf(47);
            file = index < 0 ? file : file.substring(index + 1);
            index = file.lastIndexOf(46);
            if (index > 0) {
                file = file.substring(0, index);
            }
            return StringTool.makeJavaIdentifier((String)file);
        }
        catch (MalformedURLException e) {
            Log.error((Object)"Error URI to name conversion", (Throwable)e);
            return "UndefinedXlsType";
        }
    }
}

