/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.extension.load.IExtensionLoader;
import org.openl.rules.extension.load.NameConventionLoaderFactory;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorksheetSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.util.PathTool;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsLoader {
    private static Log LOG = LogFactory.getLog(XlsLoader.class);
    private static final String[][] headerMapping = new String[][]{{"DT", XlsNodeTypes.XLS_DT.toString()}, {"Rules", XlsNodeTypes.XLS_DT.toString()}, {"SimpleRules", XlsNodeTypes.XLS_DT.toString()}, {"SimpleLookup", XlsNodeTypes.XLS_DT.toString()}, {"Spreadsheet", XlsNodeTypes.XLS_SPREADSHEET.toString()}, {"Calc", XlsNodeTypes.XLS_SPREADSHEET.toString()}, {"TBasic", XlsNodeTypes.XLS_TBASIC.toString()}, {"Algorithm", XlsNodeTypes.XLS_TBASIC.toString()}, {"ColumnMatch", XlsNodeTypes.XLS_COLUMN_MATCH.toString()}, {"Data", XlsNodeTypes.XLS_DATA.toString()}, {"Datatype", XlsNodeTypes.XLS_DATATYPE.toString()}, {"Code", XlsNodeTypes.XLS_METHOD.toString()}, {"Method", XlsNodeTypes.XLS_METHOD.toString()}, {"Environment", XlsNodeTypes.XLS_ENVIRONMENT.toString()}, {"Testmethod", XlsNodeTypes.XLS_TEST_METHOD.toString()}, {"Runmethod", XlsNodeTypes.XLS_RUN_METHOD.toString()}, {"Persistent", XlsNodeTypes.XLS_PERSISTENT.toString()}, {"Properties", XlsNodeTypes.XLS_PROPERTIES.toString()}};
    private static Map<String, String> tableHeaders;
    private List<String> imports = new ArrayList<String>();
    private String searchPath;
    private IConfigurableResourceContext ucxt;
    private OpenlSyntaxNode openl;
    private IdentifierNode vocabulary;
    private List<ISyntaxNode> nodesList = new ArrayList<ISyntaxNode>();
    private List<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
    private List<IdentifierNode> extensionNodes = new ArrayList<IdentifierNode>();
    private HashSet<String> preprocessedWorkBooks = new HashSet();
    private List<WorkbookSyntaxNode> workbookNodes = new ArrayList<WorkbookSyntaxNode>();

    public XlsLoader(IConfigurableResourceContext ucxt, String searchPath) {
        this.ucxt = ucxt;
        this.searchPath = searchPath;
    }

    public static Map<String, String> getTableHeaders() {
        return tableHeaders;
    }

    public void addError(SyntaxNodeException error) {
        this.errors.add(error);
    }

    public void addNode(ISyntaxNode node) {
        this.nodesList.add(node);
    }

    public void addExtensionNode(IdentifierNode node) {
        this.extensionNodes.add(node);
    }

    public Set<String> getPreprocessedWorkBooks() {
        return this.preprocessedWorkBooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IOpenSourceCodeModule findInclude(String include) {
        if (this.searchPath == null) {
            this.searchPath = "include/";
        }
        String[] path = StringTool.tokenize((String)this.searchPath, (String)";");
        for (int i = 0; i < path.length; ++i) {
            String p = PathTool.mergePath((String)path[i], (String)include);
            URL url = this.ucxt.findClassPathResource(p);
            if (url != null) {
                return new URLSourceCodeModule(url);
            }
            File f = this.ucxt.findFileSystemResource(p);
            if (f != null) {
                return new FileSourceCodeModule(f, null);
            }
            String u2 = path[i] + include;
            URL xurl = new URL(u2);
            InputStream is = null;
            try {
                is = xurl.openStream();
                if (is == null) return new URLSourceCodeModule(xurl);
            }
            catch (IOException iox) {
                IOpenSourceCodeModule iOpenSourceCodeModule;
                try {
                    iOpenSourceCodeModule = null;
                    if (is == null) return iOpenSourceCodeModule;
                }
                catch (Throwable throwable) {
                    try {
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        OpenLMessagesUtils.addWarn((String)String.format("Cannot find '%s' ()", include, t.getMessage()));
                        continue;
                    }
                }
                is.close();
                return iOpenSourceCodeModule;
            }
            is.close();
            return new URLSourceCodeModule(xurl);
        }
        return null;
    }

    public IParsedCode parse(IOpenSourceCodeModule source) {
        this.preprocessWorkbook(source);
        this.addInnerImports();
        return new ParsedCode((ISyntaxNode)new XlsModuleSyntaxNode(this.workbookNodes.toArray(new WorkbookSyntaxNode[0]), source, this.openl, this.vocabulary, this.imports, this.extensionNodes), source, this.errors.toArray(new SyntaxNodeException[0]));
    }

    private void preprocessEnvironmentTable(TableSyntaxNode tableSyntaxNode, XlsSheetSourceCodeModule source) {
        ILogicalTable logicalTable = tableSyntaxNode.getTable();
        int height = logicalTable.getHeight();
        for (int i = 1; i < height; ++i) {
            ILogicalTable row = (ILogicalTable)logicalTable.getRow(i);
            String name = ((ILogicalTable)row.getColumn(0)).getSource().getCell(0, 0).getStringValue();
            if ("language".equals(name)) {
                this.preprocessOpenlTable(row.getSource(), source);
                continue;
            }
            if ("include".equals(name)) {
                this.preprocessIncludeTable(tableSyntaxNode, row.getSource(), source);
                continue;
            }
            if ("import".equals(name)) {
                this.preprocessImportTable(row.getSource(), source);
                continue;
            }
            if ("vocabulary".equals(name)) {
                this.preprocessVocabularyTable(row.getSource(), source);
                continue;
            }
            if (StringUtils.isBlank((String)name) || DecisionTableHelper.isValidCommentHeader(name)) continue;
            IExtensionLoader loader = NameConventionLoaderFactory.INSTANCE.getLoader(name);
            if (loader != null) {
                loader.process(this, tableSyntaxNode, tableSyntaxNode.getGridTable(), source);
                continue;
            }
            LOG.warn((Object)String.format("Doesn't find extension loader for '%s'", name));
        }
    }

    private void preprocessImportTable(IGridTable table, XlsSheetSourceCodeModule sheetSource) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            String singleImport = table.getCell(1, i).getStringValue();
            if (StringUtils.isNotBlank((String)singleImport)) {
                singleImport = singleImport.trim();
            }
            if (!StringUtils.isNotEmpty((String)singleImport)) continue;
            this.addImport(singleImport);
        }
    }

    private void addImport(String singleImport) {
        if (!this.imports.contains(singleImport)) {
            this.imports.add(singleImport);
        }
    }

    private void addInnerImports() {
        this.addImport("org.openl.rules.enumeration");
    }

    private void preprocessIncludeTable(TableSyntaxNode tableSyntaxNode, IGridTable table, XlsSheetSourceCodeModule sheetSource) {
        int height = table.getHeight();
        for (int i = 0; i < height; ++i) {
            String include = table.getCell(1, i).getStringValue();
            if (!StringUtils.isNotBlank((String)include)) continue;
            include = include.trim();
            IOpenSourceCodeModule src = null;
            if (include.startsWith("<")) {
                src = this.findInclude(StringTool.openBrackets((String)include, (char)'<', (char)'>', (String)"")[0]);
                if (src == null) {
                    this.registerError(tableSyntaxNode, table, i, include, null);
                    continue;
                }
            } else {
                try {
                    String newURL = PathTool.mergePath((String)sheetSource.getWorkbookSource().getUri(0), (String)include);
                    src = new URLSourceCodeModule(new URL(newURL));
                }
                catch (Throwable t) {
                    this.registerError(tableSyntaxNode, table, i, include, t);
                    continue;
                }
            }
            try {
                this.preprocessWorkbook(src);
                continue;
            }
            catch (Throwable t) {
                this.registerError(tableSyntaxNode, table, i, include, t);
            }
        }
    }

    private void registerError(TableSyntaxNode tableSyntaxNode, IGridTable table, int i, String include, Throwable t) {
        SyntaxNodeException se = SyntaxNodeExceptionUtils.createError((String)("Include " + include + " not found"), (Throwable)t, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule((IGridTable)table.getSubtable(1, i, 1, 1)));
        this.addError(se);
        tableSyntaxNode.addError(se);
        OpenLMessagesUtils.addError((String)se.getMessage());
    }

    private void preprocessOpenlTable(IGridTable table, XlsSheetSourceCodeModule source) {
        String openlName = table.getCell(1, 0).getStringValue();
        this.setOpenl(new OpenlSyntaxNode(openlName, new GridLocation(table), source));
    }

    private TableSyntaxNode preprocessTable(IGridTable table, XlsSheetSourceCodeModule source) throws OpenLCompilationException {
        GridCellSourceCodeModule src = new GridCellSourceCodeModule(table);
        IdentifierNode headerToken = Tokenizer.firstToken((IOpenSourceCodeModule)src, (String)" \n\r");
        HeaderSyntaxNode headerNode = new HeaderSyntaxNode(src, headerToken);
        String header = headerToken.getIdentifier();
        String xls_type = XlsLoader.getTableHeaders().get(header);
        if (xls_type == null) {
            xls_type = XlsNodeTypes.XLS_OTHER.toString();
        }
        TableSyntaxNode tsn = new TableSyntaxNode(xls_type, new GridLocation(table), source, table, headerNode);
        if (header.equals("Environment")) {
            this.preprocessEnvironmentTable(tsn, source);
        }
        this.addNode((ISyntaxNode)tsn);
        return tsn;
    }

    private void preprocessVocabularyTable(IGridTable table, XlsSheetSourceCodeModule source) {
        String vocabularyStr = table.getCell(1, 0).getStringValue();
        this.setVocabulary(new IdentifierNode("vocabulary", (ILocation)new GridLocation(table), vocabularyStr, (IOpenSourceCodeModule)source));
    }

    private WorkbookSyntaxNode preprocessWorkbook(IOpenSourceCodeModule source) {
        String uri = source.getUri(0);
        if (this.preprocessedWorkBooks.contains(uri)) {
            return null;
        }
        this.preprocessedWorkBooks.add(uri);
        InputStream is = null;
        Workbook workbook = null;
        try {
            is = source.getByteStream();
            workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while preprocessing workbook", (Throwable)e);
            String message = "Cannot open source file or file is corrupted";
            OpenLRuntimeException error = new OpenLRuntimeException(message);
            OpenLMessagesUtils.addError((Throwable)error);
            throw error;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Error trying close input stream:", e);
                return null;
            }
        }
        XlsWorkbookSourceCodeModule workbookSourceModule = new XlsWorkbookSourceCodeModule(source, workbook);
        int nsheets = workbook.getNumberOfSheets();
        WorksheetSyntaxNode[] sheetNodes = new WorksheetSyntaxNode[nsheets];
        for (int i = 0; i < nsheets; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            XlsSheetSourceCodeModule sheetSource = this.preprocessSheet(sheet, workbookSourceModule);
            IGridTable[] tables = this.getAllGridTables(sheetSource);
            ArrayList<TableSyntaxNode> tableNodes = new ArrayList<TableSyntaxNode>();
            for (int j = 0; j < tables.length; ++j) {
                try {
                    TableSyntaxNode tsn = this.preprocessTable(tables[j], sheetSource);
                    tableNodes.add(tsn);
                    continue;
                }
                catch (OpenLCompilationException e) {
                    OpenLMessagesUtils.addError((OpenLCompilationException)e);
                }
            }
            sheetNodes[i] = new WorksheetSyntaxNode(tableNodes.toArray(new TableSyntaxNode[0]), sheetSource);
        }
        WorkbookSyntaxNode workbookNode = new WorkbookSyntaxNode(sheetNodes, workbookSourceModule);
        this.workbookNodes.add(workbookNode);
        return workbookNode;
    }

    private IGridTable[] getAllGridTables(XlsSheetSourceCodeModule sheetSource) {
        XlsSheetGridModel xlsGrid = new XlsSheetGridModel(sheetSource);
        IGridTable[] tables = xlsGrid.getTables();
        return tables;
    }

    private XlsSheetSourceCodeModule preprocessSheet(Sheet sheet, XlsWorkbookSourceCodeModule workbookSourceModule) {
        String sheetName = sheet.getSheetName();
        return new XlsSheetSourceCodeModule(sheet, sheetName, workbookSourceModule);
    }

    private void setOpenl(OpenlSyntaxNode openl) {
        if (this.openl == null) {
            this.openl = openl;
        } else if (!this.openl.getOpenlName().equals(openl.getOpenlName())) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Only one openl statement is allowed", null, (ISyntaxNode)openl);
            OpenLMessagesUtils.addError((String)error.getMessage());
            this.addError(error);
        }
    }

    private void setVocabulary(IdentifierNode vocabulary) {
        if (this.vocabulary == null) {
            this.vocabulary = vocabulary;
        } else {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Only one vocabulary is allowed", null, (ISyntaxNode)vocabulary);
            OpenLMessagesUtils.addError((String)error.getMessage());
            this.addError(error);
        }
    }

    static {
        if (tableHeaders == null) {
            tableHeaders = new HashMap<String, String>();
            for (int i = 0; i < headerMapping.length; ++i) {
                tableHeaders.put(headerMapping[i][0], headerMapping[i][1]);
            }
        }
    }
}

