/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.IOpenParser;
import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IUserContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.util.PropertiesLocator;

public class XlsParser
implements IOpenParser {
    private static final String SEARCH_PROPERTY_NAME = "org.openl.rules.include";
    private static final String SEARCH_FILE_NAME = "org/openl/rules/org.openl.rules.include.properties";
    private IConfigurableResourceContext resourceContext;
    private String searchPath;

    public XlsParser(IUserContext userContext) {
        this.resourceContext = new ConfigurableResourceContext(userContext.getUserClassLoader(), new String[]{userContext.getUserHome()});
    }

    protected String getSearchPath() {
        if (this.searchPath == null) {
            this.searchPath = PropertiesLocator.findPropertyValue((String)SEARCH_PROPERTY_NAME, (String)SEARCH_FILE_NAME, (IConfigurableResourceContext)this.resourceContext);
        }
        return this.searchPath;
    }

    public IParsedCode parseAsMethodBody(IOpenSourceCodeModule source) {
        String message = ".xls files can not be parsed as a Method Body";
        return this.getInvalidCode(message, source);
    }

    public IParsedCode parseAsMethodHeader(IOpenSourceCodeModule source) {
        String message = ".xls files can not be parsed as a Method Header";
        return this.getInvalidCode(message, source);
    }

    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        XlsLoader xlsLoader = new XlsLoader(this.resourceContext, this.getSearchPath());
        return xlsLoader.parse(source);
    }

    public IParsedCode parseAsType(IOpenSourceCodeModule source) {
        String message = ".xls files can not be parsed as a Type";
        return this.getInvalidCode(message, source);
    }

    public IParsedCode parseAsFloatRange(IOpenSourceCodeModule source) {
        String message = ".xls files can not be parsed as a float range";
        return this.getInvalidCode(message, source);
    }

    public IParsedCode parseAsIntegerRange(IOpenSourceCodeModule source) {
        String message = ".xls files can not be parsed as a integer range";
        return this.getInvalidCode(message, source);
    }

    private IParsedCode getInvalidCode(String message, IOpenSourceCodeModule source) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
        OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
        SyntaxNodeException[] errors = new SyntaxNodeException[]{error};
        return new ParsedCode(null, source, errors);
    }
}

