/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.SourceCodeModuleDelegator;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;

public class XlsWorkbookSourceCodeModule
extends SourceCodeModuleDelegator
implements IIndexElement {
    private Workbook workbook;
    private Collection<WorkbookListener> listeners = new ArrayList<WorkbookListener>();
    File sourceFile;
    private long lastModified;

    public XlsWorkbookSourceCodeModule(IOpenSourceCodeModule src) {
        this(src, XlsWorkbookSourceCodeModule.loadWorkbook(src));
    }

    public XlsWorkbookSourceCodeModule(IOpenSourceCodeModule src, Workbook workbook) {
        super(src);
        this.workbook = workbook;
        this.initSourceFile();
    }

    private static Workbook loadWorkbook(IOpenSourceCodeModule src) {
        InputStream is = null;
        try {
            is = src.getByteStream();
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            return workbook;
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {
                Log.error((Object)"Error trying close input stream:", (Throwable)e);
            }
        }
    }

    private void initSourceFile() {
        try {
            this.sourceFile = this.getFile();
            this.lastModified = this.sourceFile.lastModified();
        }
        catch (Exception e) {
            Log.error((Object)"Error when trying to get source file", (Throwable)e);
        }
    }

    public void addListener(WorkbookListener listener) {
        this.listeners.add(listener);
    }

    public String getCategory() {
        return IDocumentType.WORKBOOK.getCategory();
    }

    public String getDisplayName() {
        String uri = this.src.getUri(0);
        try {
            URL url = new URL(uri);
            String file = url.getFile();
            int index = file.lastIndexOf(47);
            return index < 0 ? file : file.substring(index + 1);
        }
        catch (MalformedURLException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    public String getIndexedText() {
        return this.getDisplayName();
    }

    public String getType() {
        return IDocumentType.WORKBOOK.getType();
    }

    public String getUri() {
        return this.src.getUri(0);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private File getFile() throws IOException {
        File sourceFile = null;
        if (this.src instanceof FileSourceCodeModule) {
            sourceFile = ((FileSourceCodeModule)this.src).getFile();
        } else if (this.src instanceof URLSourceCodeModule) {
            sourceFile = new File(((URLSourceCodeModule)this.src).getUrl().getFile());
        } else {
            try {
                sourceFile = new File(new URI(this.getUri()));
            }
            catch (URISyntaxException me) {
                throw new IOException("The xls source is not file based");
            }
        }
        return sourceFile;
    }

    public boolean isModified() {
        if (this.sourceFile == null) {
            Log.warn((Object)String.format("Undefined source file for [%s]", this.getUri()));
            return false;
        }
        return this.sourceFile.lastModified() != this.lastModified;
    }

    public void save() throws IOException {
        String fileName = this.sourceFile.getCanonicalPath();
        this.saveAs(fileName);
    }

    public void saveAs(String fileName) throws IOException {
        for (WorkbookListener wl : this.listeners) {
            wl.beforeSave(this);
        }
        FileOutputStream fileOut = new FileOutputStream(fileName);
        this.workbook.write((OutputStream)fileOut);
        fileOut.close();
    }

    public static interface WorkbookListener
    extends EventListener {
        public void beforeSave(XlsWorkbookSourceCodeModule var1);
    }
}

