/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IMemberBoundNode;
import org.openl.engine.OpenLManager;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.impl.OpenMethodHeader;

public abstract class AExecutableNodeBinder
extends AXlsTableBinder {
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        OpenMethodHeader header = this.createHeader(tableSyntaxNode, openl, bindingContext);
        header.setDeclaringClass((IOpenClass)module);
        this.checkForDuplicates(tableSyntaxNode, (RulesModuleBindingContext)bindingContext, header);
        return this.createNode(tableSyntaxNode, openl, header, module);
    }

    protected OpenMethodHeader createHeader(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext) throws Exception {
        IGridTable table = tableSyntaxNode.getGridTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table, bindingContext);
        SubTextSourceCodeModule headerSource = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, tableSyntaxNode.getHeader().getHeaderToken().getIdentifier().length());
        IBindingContextDelegator bindingContextDelegator = (IBindingContextDelegator)bindingContext;
        return (OpenMethodHeader)OpenLManager.makeMethodHeader((OpenL)openl, (IOpenSourceCodeModule)headerSource, (IBindingContextDelegator)bindingContextDelegator);
    }

    protected abstract IMemberBoundNode createNode(TableSyntaxNode var1, OpenL var2, OpenMethodHeader var3, XlsModuleOpenClass var4);

    private void checkForDuplicates(TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext bindingContext, OpenMethodHeader header) throws DuplicatedTableException {
        String key = this.makeKey(tableSyntaxNode, header);
        if (bindingContext.isTableSyntaxNodeExist(key)) {
            throw new DuplicatedTableException(tableSyntaxNode.getDisplayName(), bindingContext.getTableSyntaxNode(key), tableSyntaxNode);
        }
        bindingContext.registerTableSyntaxNode(key, tableSyntaxNode);
    }

    private String makeKey(TableSyntaxNode tableSyntaxNode, OpenMethodHeader header) {
        StringBuilder builder = new StringBuilder();
        builder.append(header.getName());
        ArrayList<String> names = new ArrayList<String>();
        for (IOpenClass parameter : header.getSignature().getParameterTypes()) {
            names.add(parameter.getName());
        }
        builder.append("(").append(StringUtils.join(names, (String)", ")).append(")");
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String property : TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
            values.add(tableProperties.getPropertyValue(property));
        }
        builder.append("[").append(StringUtils.join(values, (String)", ")).append(tableProperties.getVersion()).append("]");
        return builder.toString();
    }
}

