/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import org.openl.OpenL;
import org.openl.binding.IBoundNode;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.vm.IRuntimeEnv;

public abstract class AMethodBasedNode
extends ATableBoundNode
implements IMemberBoundNode {
    private OpenL openl;
    private IOpenMethodHeader header;
    private IOpenMethod method;
    private ModuleOpenClass module;

    public AMethodBasedNode(TableSyntaxNode methodNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(methodNode, new IBoundNode[0]);
        this.header = header;
        this.openl = openl;
        this.module = module;
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    public IOpenMethodHeader getHeader() {
        return this.header;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    public boolean isLiteralExpressionParent() {
        return false;
    }

    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        throw new UnsupportedOperationException("Should not be called");
    }

    public IOpenClass getType() {
        return this.header.getType();
    }

    public void addTo(ModuleOpenClass openClass) {
        this.method = this.createMethodShell();
        try {
            openClass.addMethod(this.method);
        }
        catch (DuplicatedMethodException e) {
            SyntaxNodeException error = new SyntaxNodeException(null, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
            this.getTableSyntaxNode().addError(error);
            OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
        }
        this.getTableSyntaxNode().setMember((IOpenMember)this.method);
    }

    protected abstract IOpenMethod createMethodShell();
}

