/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.HashMap;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.data.DataBase;
import org.openl.rules.data.IDataBase;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsModuleOpenClass
extends ModuleOpenClass {
    private Map<String, IOpenClass> internalTypes = new HashMap<String, IOpenClass>();
    private IDataBase dataBase = new DataBase();

    public XlsModuleOpenClass(IOpenSchema schema, String name, XlsMetaInfo metaInfo, OpenL openl) {
        super(schema, name, openl);
        this.metaInfo = metaInfo;
    }

    public IDataBase getDataBase() {
        return this.dataBase;
    }

    public XlsMetaInfo getXlsMetaInfo() {
        return (XlsMetaInfo)this.metaInfo;
    }

    public void addType(String namespace, IOpenClass type) throws Exception {
        String typeName = this.buildFullTypeName(namespace, type.getName());
        if (this.internalTypes.containsKey(typeName)) {
            throw new Exception("The type " + typeName + " has been defined already");
        }
        this.internalTypes.put(typeName, type);
    }

    public IOpenClass findType(String namespace, String typeName) {
        String name = this.buildFullTypeName(namespace, typeName);
        return this.internalTypes.get(name);
    }

    public void addMethod(IOpenMethod method) {
        MethodKey key = new MethodKey(method);
        Map methods = this.methodMap();
        if (methods.containsKey(key)) {
            IOpenMethod existedMethod = (IOpenMethod)methods.get(key);
            if (!existedMethod.getType().equals(method.getType())) {
                throw new DuplicatedMethodException(String.format("Method \"%s\" with return type \"%s\" has already been defined with another return type (\"%s\")", method.getName(), method.getType().getDisplayName(0), existedMethod.getType().getDisplayName(0)), method);
            }
            if (existedMethod instanceof OpenMethodDispatcher) {
                OpenMethodDispatcher decorator = (OpenMethodDispatcher)existedMethod;
                decorator.addMethod(method);
            } else {
                MatchingOpenMethodDispatcher decorator = new MatchingOpenMethodDispatcher(existedMethod, this);
                decorator.addMethod(method);
                this.methodMap().put(key, decorator);
            }
        } else {
            this.methodMap().put(key, method);
        }
    }

    private String buildFullTypeName(String namespace, String type) {
        return String.format("%s.%s", namespace, type);
    }

    public Map<String, IOpenClass> getTypes() {
        return new HashMap<String, IOpenClass>(this.internalTypes);
    }

    public void clearOddDataForExecutionMode() {
        super.clearOddDataForExecutionMode();
        this.dataBase = null;
    }
}

