/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSyntaxNodeAdapter
implements IOpenLTable {
    private TableSyntaxNode tsn;

    public TableSyntaxNodeAdapter(TableSyntaxNode tsn) {
        if (tsn == null) {
            throw new IllegalArgumentException("TableSyntaxNode is null");
        }
        this.tsn = tsn;
    }

    @Override
    public IGridTable getGridTable() {
        return this.tsn.getGridTable();
    }

    @Override
    public IGridTable getGridTable(String view) {
        ILogicalTable gtx;
        if (view != null && (gtx = this.tsn.getSubTables().get(view)) != null) {
            return gtx.getSource();
        }
        return this.getGridTable();
    }

    @Override
    public ITableProperties getProperties() {
        return this.tsn.getTableProperties();
    }

    @Override
    public String getType() {
        return this.tsn.getType();
    }

    @Override
    public List<OpenLMessage> getMessages() {
        SyntaxNodeException[] errors = this.tsn.getErrors();
        return OpenLMessagesUtils.newMessages((OpenLException[])errors);
    }

    public String getNameFromHeader() {
        IOpenMember member = this.tsn.getMember();
        if (member != null) {
            return member.getName();
        }
        return "";
    }

    @Override
    public String getName() {
        String tableName = this.getNameFromHeader();
        ITableProperties properties = this.getProperties();
        if (properties != null) {
            String name = properties.getName();
            String version = properties.getVersion();
            if (StringUtils.isNotBlank((String)name)) {
                tableName = name;
            }
            if (StringUtils.isNotBlank((String)version)) {
                return String.format("%s: %s", tableName, version);
            }
        }
        return tableName;
    }

    @Override
    public boolean isExecutable() {
        return this.tsn.isExecutableNode();
    }

    @Override
    public String getUri() {
        return this.tsn.getUri();
    }

    @Override
    public boolean isVersionable() {
        return PropertiesChecker.isPropertySuitableForTableType("version", this.tsn.getType());
    }
}

