/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.NaryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsModuleSyntaxNode
extends NaryNode {
    private List<IdentifierNode> extensionNodes;
    private OpenlSyntaxNode openlNode;
    private IdentifierNode vocabularyNode;
    private List<String> allImports = new ArrayList<String>();

    public XlsModuleSyntaxNode(WorkbookSyntaxNode[] nodes, IOpenSourceCodeModule module, OpenlSyntaxNode openlNode, IdentifierNode vocabularyNode, List<String> allImports, List<IdentifierNode> extensionNodes) {
        super(XlsNodeTypes.XLS_MODULE.toString(), null, (ISyntaxNode[])nodes, module);
        this.openlNode = openlNode;
        this.vocabularyNode = vocabularyNode;
        this.allImports = allImports;
        this.extensionNodes = extensionNodes;
    }

    public List<String> getAllImports() {
        return this.allImports;
    }

    public OpenlSyntaxNode getOpenlNode() {
        return this.openlNode;
    }

    public IdentifierNode getVocabularyNode() {
        return this.vocabularyNode;
    }

    public WorkbookSyntaxNode[] getWorkbookSyntaxNodes() {
        return (WorkbookSyntaxNode[])this.getNodes();
    }

    public TableSyntaxNode[] getXlsTableSyntaxNodes() {
        ArrayList<TableSyntaxNode> tsnodes = new ArrayList<TableSyntaxNode>();
        for (WorkbookSyntaxNode wbsn : this.getWorkbookSyntaxNodes()) {
            for (TableSyntaxNode tableSyntaxNode : wbsn.getTableSyntaxNodes()) {
                tsnodes.add(tableSyntaxNode);
            }
        }
        return tsnodes.toArray(new TableSyntaxNode[tsnodes.size()]);
    }

    public List<IdentifierNode> getExtensionNodes() {
        return this.extensionNodes;
    }

    public TableSyntaxNode[] getXlsTableSyntaxNodesWithoutErrors() {
        ArrayList<TableSyntaxNode> resultNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode node : this.getXlsTableSyntaxNodes()) {
            SyntaxNodeException[] errors = node.getErrors();
            if (errors != null && errors.length > 0) continue;
            resultNodes.add(node);
        }
        return resultNodes.toArray(new TableSyntaxNode[resultNodes.size()]);
    }
}

