/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodSignature;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.AOpenIterator;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeOpenClass
extends ADynamicClass {
    private static final Log LOG = LogFactory.getLog(DatatypeOpenClass.class);
    private IOpenClass superClass;
    private String packageName;

    public DatatypeOpenClass(IOpenSchema schema, String name, String packageName) {
        super(schema, name, null);
        this.addMethod(new EqualsMethod((IOpenClass)this));
        this.addMethod(new HashCodeMethod((IOpenClass)this));
        this.addMethod(new ToStringMethod((IOpenClass)this));
        this.packageName = packageName;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public IOpenClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(IOpenClass superClass) {
        this.superClass = superClass;
    }

    public Iterator<IOpenClass> superClasses() {
        if (this.superClass != null) {
            return AOpenIterator.single((Object)this.superClass);
        }
        return AOpenIterator.empty();
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected LinkedHashMap<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new LinkedHashMap();
        }
        return (LinkedHashMap)this.fieldMap;
    }

    public Map<String, IOpenField> getFields() {
        LinkedHashMap<String, IOpenField> fields = new LinkedHashMap<String, IOpenField>();
        Iterator<IOpenClass> superClasses = this.superClasses();
        while (superClasses.hasNext()) {
            fields.putAll(superClasses.next().getFields());
        }
        fields.putAll(this.fieldMap());
        return fields;
    }

    public Map<String, IOpenField> getDeclaredFields() {
        return (Map)((HashMap)this.fieldMap()).clone();
    }

    public Object newInstance(IRuntimeEnv env) {
        Object instance = null;
        try {
            instance = this.getInstanceClass().newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)this, (Throwable)e);
        }
        return instance;
    }

    public static class HashCodeMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public HashCodeMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.INT;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "hashCode";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            HashCodeBuilder builder = new HashCodeBuilder();
            Map fields = this.openClass.getFields();
            for (IOpenField field : fields.values()) {
                builder.append(field.get(target, env));
            }
            return builder.toHashCode();
        }
    }

    public static class EqualsMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public EqualsMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IOpenClass[]{JavaOpenClass.OBJECT});
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.BOOLEAN;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "equals";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            EqualsBuilder builder = new EqualsBuilder();
            Map fields = this.openClass.getFields();
            for (IOpenField field : fields.values()) {
                builder.append(field.get(target, env), field.get(params[0], env));
            }
            return builder.isEquals();
        }
    }

    public static class ToStringMethod
    implements IOpenMethod {
        private IOpenClass openClass;

        public ToStringMethod(IOpenClass forClass) {
            this.openClass = forClass;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getType() {
            return JavaOpenClass.STRING;
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName(int mode) {
            return this.getName();
        }

        public String getName() {
            return "toString";
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            StringBuilder builder = new StringBuilder(this.openClass.getDisplayName(0) + "{ ");
            Map fields = this.openClass.getFields();
            for (Map.Entry field : fields.entrySet()) {
                builder.append((String)field.getKey() + "=" + ((IOpenField)field.getValue()).get(target, env) + " ");
            }
            builder.append('}');
            return builder.toString();
        }
    }

    public static class OpenFieldsConstructor
    implements IOpenMethod {
        IOpenClass openClass;

        public OpenFieldsConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        public IMethodSignature getSignature() {
            Map fields = this.openClass.getFields();
            IOpenClass[] params = new IOpenClass[fields.size()];
            String[] names = new String[fields.size()];
            int i = 0;
            for (Map.Entry field : fields.entrySet()) {
                params[i] = ((IOpenField)field.getValue()).getType();
                names[i] = (String)field.getKey();
                ++i;
            }
            return new MethodSignature(params, names);
        }

        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            Object result = this.openClass.newInstance(env);
            int i = 0;
            for (IOpenField field : this.openClass.getFields().values()) {
                field.set(result, params[i], env);
                ++i;
            }
            return result;
        }

        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }
    }
}

