/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.method;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.TableMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;

public class MethodTableBoundNode
extends AMethodBasedNode {
    public MethodTableBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    protected IOpenMethod createMethodShell() {
        return new TableMethod(this.getHeader(), null, this);
    }

    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        TableSyntaxNode tsn = this.getTableSyntaxNode();
        ILogicalTable logicalTable = tsn.getTable();
        boolean tableHasProperties = tsn.hasPropertiesDefinedInTable();
        ILogicalTable bodyTable = (ILogicalTable)logicalTable.getRows(tableHasProperties ? 2 : 1);
        int height = bodyTable.getHeight();
        IOpenSourceCodeModule[] cellSources = new IOpenSourceCodeModule[height];
        for (int i = 0; i < height; ++i) {
            cellSources[i] = new GridCellSourceCodeModule(((ILogicalTable)bodyTable.getRow(i)).getSource(), bindingContext);
        }
        CompositeSourceCodeModule src = new CompositeSourceCodeModule(cellSources, "\n");
        OpenLManager.compileMethod((OpenL)this.getOpenl(), (IOpenSourceCodeModule)src, (CompositeMethod)this.getTableMethod(), (IBindingContext)bindingContext);
        if (bindingContext.isExecutionMode()) {
            this.getTableMethod().setMethodTableBoundNode(null);
        }
    }

    public IOpenClass getType() {
        return this.getHeader().getType();
    }

    public void updateDependency(BindingDependencies dependencies) {
        this.getTableMethod().getMethodBodyBoundNode().updateDependency(dependencies);
    }

    private TableMethod getTableMethod() {
        return (TableMethod)this.getMethod();
    }
}

