/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.method.MethodTableTraceObject;
import org.openl.rules.method.TableMethod;
import org.openl.rules.table.InvokerWithTrace;
import org.openl.types.impl.CompositeMethodInvoker;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class MethodTableInvoker
extends CompositeMethodInvoker
implements InvokerWithTrace {
    private final Log LOG = LogFactory.getLog(MethodTableInvoker.class);
    private TableMethod tableMethod;

    public MethodTableInvoker(TableMethod tableMethod) {
        super(tableMethod.getMethodBodyBoundNode());
        this.tableMethod = tableMethod;
    }

    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        return super.invoke(target, params, env);
    }

    public Object invokeTraced(Object target, Object[] params, IRuntimeEnv env) {
        Tracer tracer = Tracer.getTracer();
        MethodTableTraceObject traceObject = this.createTraceObject(params);
        tracer.push((ITracerObject)traceObject);
        Object result = null;
        try {
            result = super.invoke(target, params, env);
            traceObject.setResult(result);
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            traceObject.setError(e);
            this.LOG.error((Object)"Error when tracing Method table", (Throwable)e);
            throw e;
        }
        finally {
            tracer.pop();
        }
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.canInvoke()) {
            if (Tracer.isTracerOn()) {
                return this.invokeTraced(target, params, env);
            }
            return super.invoke(target, params, env);
        }
        OpenLRuntimeException error = this.getError();
        if (Tracer.isTracerOn()) {
            this.setErrorToTrace(error, params);
        }
        throw error;
    }

    public boolean canInvoke() {
        return this.getMethodBodyBoundNode() != null;
    }

    public MethodTableTraceObject createTraceObject(Object[] params) {
        return new MethodTableTraceObject(this.tableMethod, params);
    }

    public OpenLRuntimeException getError() {
        return new OpenLRuntimeException((Throwable)this.tableMethod.getSyntaxNode().getErrors()[0]);
    }

    public void setErrorToTrace(OpenLRuntimeException error, Object[] params) {
        Tracer tracer = Tracer.getTracer();
        MethodTableTraceObject traceObject = this.createTraceObject(params);
        traceObject.setError((Throwable)error);
        tracer.push((ITracerObject)traceObject);
        tracer.pop();
    }
}

