/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.method;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.method.TableMethod;
import org.openl.rules.table.ATableTracerNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.types.IOpenMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTableTraceObject
extends ATableTracerNode {
    private static final String METHOD_TABLE_TYPE = "method";

    public MethodTableTraceObject(TableMethod method, Object[] params) {
        super(method, params);
    }

    public TableMethod getMethod() {
        return (TableMethod)((Object)this.getTraceObject());
    }

    public String getUri() {
        return this.getMethod().getSourceUrl();
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        ICell cell;
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        IGridTable tableBodyGrid = this.getMethod().getSyntaxNode().getTableBody().getSource();
        for (int row = 0; row < tableBodyGrid.getHeight(); row += cell.getHeight()) {
            cell = tableBodyGrid.getCell(0, row);
            regions.add(cell.getAbsoluteRegion());
        }
        return regions;
    }

    public String getType() {
        return METHOD_TABLE_TYPE;
    }

    public String getDisplayName(int mode) {
        return "Method table " + this.asString((IOpenMethod)this.getMethod(), mode);
    }
}

