/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessages;
import org.openl.rules.runtime.RulesFactory;
import org.openl.runtime.AEngineFactory;
import org.openl.runtime.ASourceCodeEngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.OpenLInvocationHandler;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiBasedRulesEngineFactory
extends ASourceCodeEngineFactory {
    public static final String RULE_OPENL_NAME = "org.openl.xls";
    private CompiledOpenClass compiledOpenClass;
    private Class<?> interfaceClass;

    public ApiBasedRulesEngineFactory(String sourceFile) {
        super(RULE_OPENL_NAME, sourceFile);
    }

    public ApiBasedRulesEngineFactory(File file) {
        super(RULE_OPENL_NAME, file);
    }

    public ApiBasedRulesEngineFactory(IOpenSourceCodeModule source) {
        super(RULE_OPENL_NAME, source);
    }

    public void reset(boolean resetInterface) {
        this.compiledOpenClass = null;
        if (resetInterface) {
            this.interfaceClass = null;
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass == null) {
            IOpenClass openClass = this.getCompiledOpenClass().getOpenClass();
            String className = openClass.getName();
            try {
                this.interfaceClass = RulesFactory.generateInterface(className, openClass, this.getDefaultUserClassLoader());
            }
            catch (Exception e) {
                throw new OpenLRuntimeException("Failed to create interface : " + className, (Throwable)e);
            }
        }
        return this.interfaceClass;
    }

    protected Class<?>[] getInstanceInterfaces() {
        return new Class[]{this.interfaceClass, IEngineWrapper.class};
    }

    public Object makeInstance() {
        try {
            this.compiledOpenClass = this.getCompiledOpenClass();
            IOpenClass openClass = this.compiledOpenClass.getOpenClassWithErrors();
            IRuntimeEnv runtimeEnv = this.getOpenL().getVm().getRuntimeEnv();
            Object openClassInstance = openClass.newInstance(runtimeEnv);
            Map methodMap = this.makeMethodMap(this.getInterfaceClass(), openClass);
            return this.makeEngineInstance(openClassInstance, methodMap, runtimeEnv, this.getDefaultUserClassLoader());
        }
        catch (Exception ex) {
            throw new OpenLRuntimeException("Cannot instantiate engine instance", (Throwable)ex);
        }
    }

    protected InvocationHandler makeInvocationHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLInvocationHandler(openClassInstance, (AEngineFactory)this, runtimeEnv, methodMap);
    }

    public CompiledOpenClass getCompiledOpenClass() {
        if (this.compiledOpenClass == null) {
            OpenLMessages.getCurrentInstance().clear();
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }
}

