/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.util.ArrayList;
import net.sf.cglib.core.ReflectUtils;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.runtime.RuleInfo;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.OpenClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesFactory {
    private static final int PUBLIC_ABSTRACT_INTERFACE = 1537;
    private static final int PUBLIC_ABSTRACT = 1025;
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";

    public static Class<?> generateInterface(String className, RuleInfo[] rules, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(false);
        String name = className.replace('.', '/');
        String sourceFileName = RulesFactory.getClassFileName(name);
        classWriter.visit(49, 1537, name, JAVA_LANG_OBJECT, null, sourceFileName);
        for (RuleInfo ruleInfo : rules) {
            String ruleName = ruleInfo.getName();
            classWriter.visitMethod(1025, ruleName, RulesFactory.getMethodTypes(ruleInfo), null, null);
        }
        classWriter.visitEnd();
        ReflectUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
        return Class.forName(className, true, classLoader);
    }

    public static Class<?> generateInterface(String className, IOpenClass openClass, ClassLoader classLoader) throws Exception {
        IOpenMember[] members;
        ArrayList<RuleInfo> rules = new ArrayList<RuleInfo>();
        for (IOpenMember member : members = OpenClassHelper.getClassMembers((IOpenClass)openClass)) {
            IOpenField field;
            RuleInfo ruleInfo;
            if (RulesFactory.isIgnoredMember(member)) continue;
            if (member instanceof IOpenMethod) {
                IOpenMethod method = (IOpenMethod)member;
                ruleInfo = RulesFactory.getRuleInfoForMethod(method);
                rules.add(ruleInfo);
            }
            if (!(member instanceof IOpenField) || !(field = (IOpenField)member).isReadable()) continue;
            ruleInfo = RulesFactory.getRuleInfoForField(field);
            rules.add(ruleInfo);
        }
        return RulesFactory.generateInterface(className, rules.toArray(new RuleInfo[rules.size()]), classLoader);
    }

    private static RuleInfo getRuleInfoForField(IOpenField field) {
        String methodName = String.format("get%s", StringUtils.capitalize((String)field.getName()));
        Class[] paramTypes = new Class[]{};
        Class returnType = field.getType().getInstanceClass();
        RuleInfo ruleInfo = RulesFactory.createRuleInfo(methodName, paramTypes, returnType);
        return ruleInfo;
    }

    private static RuleInfo getRuleInfoForMethod(IOpenMethod method) {
        String methodName = method.getName();
        IOpenClass[] paramClasses = method.getSignature().getParameterTypes();
        Class returnType = method.getType().getInstanceClass();
        Class[] paramTypes = OpenClassHelper.getInstanceClasses((IOpenClass[])paramClasses);
        RuleInfo ruleInfo = RulesFactory.createRuleInfo(methodName, paramTypes, returnType);
        return ruleInfo;
    }

    public static RuleInfo createRuleInfo(String ruleName, Class<?>[] paramTypes, Class<?> returnType) {
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setName(ruleName);
        ruleInfo.setParamTypes(paramTypes);
        ruleInfo.setReturnType(returnType);
        return ruleInfo;
    }

    private static boolean isIgnoredMember(IOpenMember member) {
        return member instanceof ADynamicClass.OpenConstructor || member instanceof JavaOpenConstructor || member instanceof ModuleOpenClass.ThisField || member instanceof ModuleOpenClass.GetOpenClass || member instanceof TestSuiteMethod;
    }

    private static String getMethodTypes(RuleInfo ruleInfo) {
        Class<?> returnType = ruleInfo.getReturnType();
        Class<?>[] paramTypes = ruleInfo.getParamTypes();
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            builder.append(Type.getType(paramTypes[i]));
        }
        builder.append(")");
        builder.append(Type.getType(returnType));
        return builder.toString();
    }

    private static String getClassFileName(String name) {
        String[] path = name.split("/");
        String className = path[path.length - 1];
        return String.format("%s.java", className);
    }
}

