/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.search.DataTableSearchInfo;
import org.openl.rules.search.DecisionTableSearchInfo;
import org.openl.rules.search.ISearchTableRow;
import org.openl.rules.search.ITableSearchInfo;
import org.openl.rules.search.TableSearchInfo;
import org.openl.util.ASelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATableRowSelector
extends ASelector<ISearchTableRow> {
    public static ITableSearchInfo getTableSearchInfo(TableSyntaxNode tsn) {
        if (XlsNodeTypes.XLS_DT.toString().equals(tsn.getType())) {
            return new DecisionTableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_DATA.toString().equals(tsn.getType())) {
            return new DataTableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_TEST_METHOD.toString().equals(tsn.getType())) {
            return new DataTableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_RUN_METHOD.toString().equals(tsn.getType())) {
            return new DataTableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_SPREADSHEET.toString().equals(tsn.getType())) {
            return new TableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_TBASIC.toString().equals(tsn.getType())) {
            return new TableSearchInfo(tsn);
        }
        if (XlsNodeTypes.XLS_COLUMN_MATCH.toString().equals(tsn.getType())) {
            return new TableSearchInfo(tsn);
        }
        return null;
    }

    public boolean select(ISearchTableRow obj) {
        return this.selectRow(obj);
    }

    public boolean selectRow(ISearchTableRow row) {
        ITableSearchInfo tsi = row.getTableSearchInfo();
        return this.isRowInTableSelected(row, tsi);
    }

    public abstract boolean isRowInTableSelected(ISearchTableRow var1, ITableSearchInfo var2);
}

