/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import org.openl.rules.search.ATableRowSelector;
import org.openl.rules.search.ColumnNameRowSelector;
import org.openl.rules.search.ColumnTypeRowSelector;
import org.openl.rules.search.ISearchConstants;
import org.openl.rules.search.ISearchTableRow;
import org.openl.rules.search.ITableSearchInfo;
import org.openl.rules.search.SearchConditionElement;

public class ColumnGroupSelector
extends ATableRowSelector
implements ISearchConstants {
    SearchConditionElement[] tableElements;
    ATableRowSelector[] selectors;

    public ColumnGroupSelector(SearchConditionElement[] tableElements) {
        this.tableElements = tableElements;
        this.init(tableElements);
    }

    void init(SearchConditionElement[] se) {
        this.selectors = new ATableRowSelector[se.length];
        for (int i = 0; i < se.length; ++i) {
            ATableRowSelector tsnSel;
            this.selectors[i] = tsnSel = this.makeTableRowSelector(se[i]);
        }
    }

    private ATableRowSelector makeTableRowSelector(SearchConditionElement se) {
        if ("Column Parameter".equals(se.getType())) {
            return new ColumnNameRowSelector(se);
        }
        if ("Column Type".equals(se.getType())) {
            return new ColumnTypeRowSelector(se);
        }
        throw new RuntimeException("Unknown selector type: " + se.getType());
    }

    public boolean isRowInTableSelected(ISearchTableRow searchTableRow, ITableSearchInfo tableSearchInfo) {
        return new GroupResult().execute(searchTableRow, tableSearchInfo);
    }

    class GroupResult {
        boolean groupRes = true;
        int currentIndex = 0;

        GroupResult() {
        }

        boolean execute(ISearchTableRow searchTableRow, ITableSearchInfo tableSearchInfo) {
            boolean res = true;
            while (this.currentIndex < ColumnGroupSelector.this.tableElements.length) {
                int oldIndex = this.currentIndex;
                boolean x = this.executeGroup(searchTableRow, tableSearchInfo);
                res = ColumnGroupSelector.this.tableElements[oldIndex].getGroupOperator().op(res, x);
            }
            return res;
        }

        boolean executeGroup(ISearchTableRow searchRatbleRow, ITableSearchInfo searchTableInfo) {
            boolean res = true;
            int elemLength = ColumnGroupSelector.this.tableElements.length;
            for (int i = this.currentIndex; i < elemLength; ++i) {
                if (i > this.currentIndex && ColumnGroupSelector.this.tableElements[i].getGroupOperator().isGroup()) {
                    this.currentIndex = i;
                    return res;
                }
                boolean x = ColumnGroupSelector.this.selectors[i].isRowInTableSelected(searchRatbleRow, searchTableInfo);
                x = ColumnGroupSelector.this.tableElements[i].isNotFlag() ? !x : x;
                res = i == this.currentIndex ? x : ColumnGroupSelector.this.tableElements[i].getGroupOperator().op(res, x);
            }
            this.currentIndex = elemLength;
            return res;
        }
    }
}

