/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import java.util.ArrayList;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.DecisionTableParameterInfo;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.search.ITableSearchInfo;
import org.openl.rules.table.IGridTable;
import org.openl.types.IOpenClass;

public class DecisionTableSearchInfo
implements ITableSearchInfo {
    private TableSyntaxNode tsn;
    private DecisionTable dt;
    private DecisionTableParameterInfo[] params;

    public DecisionTableSearchInfo(TableSyntaxNode tsn) {
        this.tsn = tsn;
        this.dt = (DecisionTable)tsn.getMember();
    }

    public String getColumnDisplay(int col) {
        return this.getParams()[col].getPresentation();
    }

    public String getColumnName(int col) {
        return this.getParams()[col].getParameterDeclaration().getName();
    }

    public IOpenClass getColumnType(int col) {
        return this.getParams()[col].getParameterDeclaration().getType();
    }

    public DecisionTableParameterInfo[] getParams() {
        if (this.params == null) {
            int j;
            int n;
            int i;
            ArrayList<DecisionTableParameterInfo> list = new ArrayList<DecisionTableParameterInfo>(20);
            for (i = 0; i < this.dt.getConditionRows().length; ++i) {
                ICondition c = this.dt.getConditionRows()[i];
                n = c.numberOfParams();
                for (j = 0; j < n; ++j) {
                    list.add(c.getParameterInfo(j));
                }
            }
            for (i = 0; i < this.dt.getActionRows().length; ++i) {
                IAction a = this.dt.getActionRows()[i];
                n = a.numberOfParams();
                for (j = 0; j < n; ++j) {
                    list.add(a.getParameterInfo(j));
                }
            }
            this.params = list.toArray(new DecisionTableParameterInfo[0]);
        }
        return this.params;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tsn;
    }

    public IGridTable getHeaderDisplayTable() {
        return this.dt.getDisplayTable().getSource();
    }

    public int getNumberOfColumns() {
        return this.getParams().length;
    }

    public int getNumberOfRows() {
        return this.dt.getNumberOfRules();
    }

    public IGridTable getRowTable(int row) {
        return this.dt.getRuleByIndex(row).getSource();
    }

    public Object getTableValue(int col, int row) {
        return this.getParams()[col].getValue(row);
    }
}

