/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

public abstract class GroupOperator {
    public static GroupOperator[] list = new GroupOperator[]{new AND(), new OR(), new GroupOR(), new GroupAND()};
    public static String[] names = new String[]{list[0].getName(), list[1].getName(), list[2].getName(), list[3].getName()};

    public static GroupOperator find(String gopID) {
        if (gopID == null) {
            return list[0];
        }
        for (int i = 0; i < names.length; ++i) {
            if (!gopID.equals(names[i])) continue;
            return list[i];
        }
        throw new RuntimeException("Operator not found: " + gopID);
    }

    public abstract String getName();

    public abstract boolean isGroup();

    public abstract boolean op(boolean var1, boolean var2);

    public static class OR
    extends GroupOperator {
        public String getName() {
            return "OR";
        }

        public boolean isGroup() {
            return false;
        }

        public boolean op(boolean b1, boolean b2) {
            return b1 || b2;
        }
    }

    public static class GroupOR
    extends GroupOperator {
        public String getName() {
            return "-OR NEXT GROUP-";
        }

        public boolean isGroup() {
            return true;
        }

        public boolean op(boolean b1, boolean b2) {
            return b1 || b2;
        }
    }

    public static class GroupAND
    extends GroupOperator {
        public String getName() {
            return "-AND NEXT GROUP-";
        }

        public boolean isGroup() {
            return true;
        }

        public boolean op(boolean b1, boolean b2) {
            return b1 && b2;
        }
    }

    public static class AND
    extends GroupOperator {
        public String getName() {
            return "AND";
        }

        public boolean isGroup() {
            return false;
        }

        public boolean op(boolean b1, boolean b2) {
            return b1 && b2;
        }
    }
}

