/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import java.util.ArrayList;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.search.ATableRowSelector;
import org.openl.rules.search.ATableSyntaxNodeSelector;
import org.openl.rules.search.ColumnGroupSelector;
import org.openl.rules.search.GroupOperator;
import org.openl.rules.search.IOpenLSearch;
import org.openl.rules.search.ISearchConstants;
import org.openl.rules.search.ISearchTableRow;
import org.openl.rules.search.ITableSearchInfo;
import org.openl.rules.search.OpenLAdvancedSearchResult;
import org.openl.rules.search.SearchConditionElement;
import org.openl.rules.search.SearchTableRow;
import org.openl.rules.search.TableGroupSelector;
import org.openl.rules.search.TableSearchInfo;
import org.openl.rules.search.TableTypeSelector;
import org.openl.util.AStringBoolOperator;
import org.openl.util.ArrayTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLAdvancedSearch
implements ISearchConstants,
IOpenLSearch {
    public static final String[] existingTableTypes = new String[]{"Rules", "Spreadsheet", "TBasic", "Column Match", "Data", "Method", "Datatype", "Test", "Run", "Env", "Other"};
    public static final String[] types = new String[]{XlsNodeTypes.XLS_DT.toString(), XlsNodeTypes.XLS_SPREADSHEET.toString(), XlsNodeTypes.XLS_TBASIC.toString(), XlsNodeTypes.XLS_COLUMN_MATCH.toString(), XlsNodeTypes.XLS_DATA.toString(), XlsNodeTypes.XLS_METHOD.toString(), XlsNodeTypes.XLS_DATATYPE.toString(), XlsNodeTypes.XLS_TEST_METHOD.toString(), XlsNodeTypes.XLS_RUN_METHOD.toString(), XlsNodeTypes.XLS_ENVIRONMENT.toString(), XlsNodeTypes.XLS_OTHER.toString()};
    public static final String[] nfValues = new String[]{"", "NOT"};
    public static final boolean[] typeNeedValue1 = new boolean[]{false, true};
    private boolean[] selectedTableTypes = new boolean[existingTableTypes.length];
    private SearchConditionElement[] tableElements = new SearchConditionElement[]{new SearchConditionElement("header")};
    private SearchConditionElement[] columnElements = new SearchConditionElement[]{new SearchConditionElement("Column Parameter")};

    private void addColumnPropertyAfter(int i) {
        this.columnElements = (SearchConditionElement[])ArrayTool.insertValue((int)(i + 1), (Object)this.columnElements, (Object)this.columnElements[i].copy());
    }

    private void addTablePropertyAfter(int i) {
        this.tableElements = (SearchConditionElement[])ArrayTool.insertValue((int)(i + 1), (Object)this.tableElements, (Object)this.tableElements[i].copy());
    }

    private void deleteColumnPropertyAt(int i) {
        this.columnElements = (SearchConditionElement[])ArrayTool.removeValue((int)i, (Object)this.columnElements);
    }

    private void deleteTablePropertyAt(int i) {
        this.tableElements = (SearchConditionElement[])ArrayTool.removeValue((int)i, (Object)this.tableElements);
    }

    private boolean isRowSelected(ISearchTableRow searchTableRow, ATableRowSelector[] rowSelectors, ITableSearchInfo tableSearchInfo) {
        for (int j = 0; j < rowSelectors.length; ++j) {
            if (rowSelectors[j].isRowInTableSelected(searchTableRow, tableSearchInfo)) continue;
            return false;
        }
        return true;
    }

    private boolean doesTableMatcheToSelectors(TableSyntaxNode tsn, ATableSyntaxNodeSelector[] tselectors) {
        for (int j = 0; j < tselectors.length; ++j) {
            if (tselectors[j].doesTableMatch(tsn)) continue;
            return false;
        }
        return true;
    }

    private ATableSyntaxNodeSelector makePropertyOrHeaderSelectors() {
        return new TableGroupSelector(this.tableElements);
    }

    private TableTypeSelector makeTableTypeSelector() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.selectedTableTypes.length; ++i) {
            if (!this.selectedTableTypes[i]) continue;
            list.add(types[i]);
        }
        String[] tt = list.toArray(new String[0]);
        return new TableTypeSelector(tt);
    }

    private void addResult(TableSyntaxNode table, OpenLAdvancedSearchResult res, ATableSyntaxNodeSelector[] tableSelectors, ATableRowSelector[] columnSelectors) {
        if (this.doesTableMatcheToSelectors(table, tableSelectors)) {
            ITableSearchInfo tablSearchInfo = ATableRowSelector.getTableSearchInfo(table);
            if (tablSearchInfo != null) {
                ArrayList<ISearchTableRow> matchedRows = this.getMatchedRows(tablSearchInfo, columnSelectors);
                res.add(table, matchedRows.toArray(new ISearchTableRow[0]));
            } else {
                res.add(table, new ISearchTableRow[0]);
            }
        }
    }

    private ArrayList<ISearchTableRow> getMatchedRows(ITableSearchInfo tablSearchInfo, ATableRowSelector[] columnSelectors) {
        ArrayList<ISearchTableRow> matchedRows = new ArrayList<ISearchTableRow>();
        int numRows = tablSearchInfo.getNumberOfRows();
        for (int row = 0; row < numRows; ++row) {
            SearchTableRow tablSearchRow = new SearchTableRow(row, tablSearchInfo);
            if (!(tablSearchInfo instanceof TableSearchInfo) && !this.isRowSelected(tablSearchRow, columnSelectors, tablSearchInfo)) continue;
            matchedRows.add(tablSearchRow);
        }
        return matchedRows;
    }

    private ATableSyntaxNodeSelector[] getTableSelectors() {
        ArrayList<ATableSyntaxNodeSelector> sll = new ArrayList<ATableSyntaxNodeSelector>();
        sll.add(this.makeTableTypeSelector());
        sll.add(this.makePropertyOrHeaderSelectors());
        return sll.toArray(new ATableSyntaxNodeSelector[0]);
    }

    public void editAction(String action) {
        if (action.startsWith("add")) {
            this.addTablePropertyAfter(Integer.parseInt(action.substring("add".length())));
        } else if (action.startsWith("delete")) {
            this.deleteTablePropertyAt(Integer.parseInt(action.substring("delete".length())));
        } else if (action.startsWith("colAdd")) {
            this.addColumnPropertyAfter(Integer.parseInt(action.substring("colAdd".length())));
        } else if (action.startsWith("colDelete")) {
            this.deleteColumnPropertyAt(Integer.parseInt(action.substring("colDelete".length())));
        }
    }

    @Deprecated
    public void fillColumnElement(int i, String gopID, String nfID, String typeID, String opType1ID, String value1ID, String opType2ID, String value2ID) {
        if (i >= this.columnElements.length) {
            return;
        }
        if (typeID == null) {
            typeID = "Column Parameter";
        }
        SearchConditionElement se = new SearchConditionElement(typeID);
        se.setGroupOperator(GroupOperator.find(gopID));
        se.setNotFlag(nfValues[1].equals(nfID));
        se.setOpType1(opType1ID);
        if (value1ID != null) {
            se.setElementValueName(value1ID);
        }
        se.setOpType2(opType2ID);
        se.setElementValue(value2ID);
        this.columnElements[i] = se;
    }

    @Deprecated
    public void fillTableElement(int i, String gopID, String nfID, String typeID, String value1ID, String opTypeID, String value2ID) {
        if (i >= this.tableElements.length) {
            return;
        }
        if (typeID == null) {
            typeID = "property";
        }
        SearchConditionElement se = new SearchConditionElement(typeID);
        se.setGroupOperator(GroupOperator.find(gopID));
        se.setNotFlag(nfValues[1].equals(nfID));
        if (value1ID != null) {
            se.setElementValueName(value1ID);
        }
        se.setOpType2(opTypeID);
        se.setElementValue(value2ID);
        this.tableElements[i] = se;
    }

    public SearchConditionElement[] getColumnElements() {
        return this.columnElements;
    }

    public String[] getGroupOperatorNames() {
        return GroupOperator.names;
    }

    public SearchConditionElement[] getTableElements() {
        return this.tableElements;
    }

    public String[] getExistingTableTypes() {
        return existingTableTypes;
    }

    public String[] opTypeValues() {
        return AStringBoolOperator.getAllOperatorNames();
    }

    public ATableRowSelector[] getColumnSelectors() {
        ArrayList<ColumnGroupSelector> list = new ArrayList<ColumnGroupSelector>();
        list.add(new ColumnGroupSelector(this.columnElements));
        return list.toArray(new ATableRowSelector[0]);
    }

    @Override
    public Object search(XlsModuleSyntaxNode xsn) {
        TableSyntaxNode[] tables;
        ATableSyntaxNodeSelector[] tableSelectors = this.getTableSelectors();
        ATableRowSelector[] columnSelectors = this.getColumnSelectors();
        OpenLAdvancedSearchResult res = new OpenLAdvancedSearchResult();
        for (TableSyntaxNode table : tables = xsn.getXlsTableSyntaxNodesWithoutErrors()) {
            if (table.hasErrors()) continue;
            this.addResult(table, res, tableSelectors, columnSelectors);
        }
        return res;
    }

    public boolean getSelectedTableType(int i) {
        return this.selectedTableTypes[i];
    }

    public void selectTableType(int i, boolean x) {
        this.selectedTableTypes[i] = x;
    }

    public void setColumnElements(SearchConditionElement[] columnElements) {
        this.columnElements = columnElements;
    }

    public void setTableElements(SearchConditionElement[] tableElements) {
        this.tableElements = tableElements;
    }

    public boolean showElementValueName(String typeValue) {
        for (int i = 0; i < typeValues.length; ++i) {
            if (!typeValues[i].equals(typeValue)) continue;
            return typeNeedValue1[i];
        }
        throw new RuntimeException("Unknown type value: " + typeValue);
    }
}

