/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.search.BussinessSearchCondition;
import org.openl.rules.search.IOpenLSearch;
import org.openl.rules.search.OpenLBussinessSearchResult;
import org.openl.rules.table.properties.ITableProperties;

public class OpenLBussinessSearch
implements IOpenLSearch {
    private BussinessSearchCondition busSearchCondit = new BussinessSearchCondition();

    public BussinessSearchCondition getBusSearchCondit() {
        return this.busSearchCondit;
    }

    public void setBusSearchCondit(BussinessSearchCondition busSearchCondit) {
        this.busSearchCondit = busSearchCondit;
    }

    public Object search(XlsModuleSyntaxNode xsn) {
        TableSyntaxNode[] tables;
        OpenLBussinessSearchResult res = new OpenLBussinessSearchResult();
        for (TableSyntaxNode table : tables = xsn.getXlsTableSyntaxNodesWithoutErrors()) {
            if (!this.isEqual(table.getTableProperties())) continue;
            res.add(table);
        }
        res = this.matchWithTableContains(res);
        return res;
    }

    private OpenLBussinessSearchResult matchWithTableContains(OpenLBussinessSearchResult busSearchRes) {
        OpenLBussinessSearchResult result = new OpenLBussinessSearchResult();
        TableSyntaxNode[] tablesContains = this.busSearchCondit.getTablesContains();
        if (tablesContains != null) {
            block0: for (TableSyntaxNode table : busSearchRes.foundTables) {
                for (TableSyntaxNode tablesConsist : tablesContains) {
                    if (!table.equals(tablesConsist)) continue;
                    result.add(table);
                    continue block0;
                }
            }
        } else {
            result = busSearchRes;
        }
        return result;
    }

    private boolean isEqual(ITableProperties tableProperties) {
        boolean result = false;
        int numMatch = 0;
        Map<String, Object> propsFromSearch = this.busSearchCondit.getPropToSearch();
        for (Map.Entry<String, Object> propertyFromSearch : propsFromSearch.entrySet()) {
            Object propertyValue;
            String propNameFromSearch = propertyFromSearch.getKey();
            Object propValueFromSearch = propertyFromSearch.getValue();
            if (tableProperties == null || (propertyValue = tableProperties.getPropertyValue(propNameFromSearch)) == null) continue;
            if (this.comparePropValues(propValueFromSearch, propertyValue) == 0) {
                ++numMatch;
                continue;
            }
            if (!(propertyValue instanceof String) || !(propValueFromSearch instanceof String) || !this.checkIfContainString(((String)propertyValue).toLowerCase(), ((String)propValueFromSearch).toLowerCase())) continue;
            ++numMatch;
        }
        result = numMatch == propsFromSearch.size() && numMatch > 0;
        return result;
    }

    private int comparePropValues(Object propValueFromSearch, Object propertyValue) {
        List<Object> propertyValueFromSearchArray;
        List<Object> propertyValueArray;
        int result = -1;
        if (propertyValue instanceof String && propValueFromSearch instanceof String) {
            result = ((String)propertyValue).compareTo((String)propValueFromSearch);
        } else if (propertyValue instanceof Date && propValueFromSearch instanceof Date) {
            result = ((Date)propertyValue).compareTo((Date)propValueFromSearch);
        } else if (propertyValue instanceof Boolean && propertyValue instanceof Boolean) {
            result = ((Boolean)propertyValue).compareTo((Boolean)propValueFromSearch);
        } else if (propertyValue instanceof Integer && propValueFromSearch instanceof Integer) {
            result = ((Integer)propertyValue).compareTo((Integer)propValueFromSearch);
        } else if (propertyValue instanceof Enum && propValueFromSearch instanceof Enum) {
            result = ((Enum)propertyValue).compareTo((Enum)propValueFromSearch);
        } else if (propertyValue.getClass().isArray() && propValueFromSearch.getClass().isArray() && (propertyValueArray = Arrays.asList((Object[])propertyValue)).containsAll(propertyValueFromSearchArray = Arrays.asList((Object[])propValueFromSearch))) {
            result = 0;
        }
        return result;
    }

    private boolean checkIfContainString(String propValue, String propValueFromSearch) {
        boolean result = false;
        if (propValue.contains(propValueFromSearch)) {
            result = true;
        }
        return result;
    }
}

