/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.search.GroupOperator;
import org.openl.rules.search.SearchConditionElement;
import org.openl.util.export.ExportRow;
import org.openl.util.export.ExportSectionSingleRow;
import org.openl.util.export.IExportRow;
import org.openl.util.export.IExportSection;
import org.openl.util.export.IExportable;
import org.openl.util.export.IImportedSection;
import org.openl.util.export.IImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLSavedSearch
implements IExportable<OpenLSavedSearch>,
IExportSection<OpenLSavedSearch> {
    private SearchConditionElement[] tableElements;
    private SearchConditionElement[] columnElements;
    private String tableTypes;
    private String name;

    private static String join(String[] strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(",").append(strings[i]);
        }
        return sb.toString();
    }

    private static SearchConditionElement[] readSearchElementSection(IImporter importer, IImportedSection section) {
        String[][] rows = importer.readRows(section.getId());
        SearchConditionElement[] searchElements = new SearchConditionElement[rows.length];
        for (int i = 0; i < searchElements.length; ++i) {
            String[] row = rows[i];
            SearchConditionElement searchElement = searchElements[i] = new SearchConditionElement(row[0]);
            searchElement.setNotFlag(Boolean.valueOf(row[1]));
            searchElement.setGroupOperator(GroupOperator.find(row[2]));
            searchElement.setOpType1(row[3]);
            searchElement.setElementValueName(row[4]);
            searchElement.setOpType2(row[5]);
            searchElement.setElementValue(row[6]);
        }
        return searchElements;
    }

    public OpenLSavedSearch() {
    }

    public OpenLSavedSearch(SearchConditionElement[] columnElements, SearchConditionElement[] tableElements, String[] tableType) {
        this.columnElements = columnElements;
        this.tableElements = tableElements;
        this.tableTypes = OpenLSavedSearch.join(tableType);
    }

    public SearchConditionElement[] getColumnElements() {
        return this.columnElements;
    }

    public Class<OpenLSavedSearch> getExportedClass() {
        return OpenLSavedSearch.class;
    }

    public String getName() {
        return StringUtils.isEmpty((String)this.name) ? "OpenL Search" : this.name;
    }

    public IExportRow[] getRows() {
        return null;
    }

    public IExportSection[] getSubSections() {
        return new IExportSection[]{new ExportSectionSingleRow("Table Type", new String[]{this.tableTypes}), new SearchElementSection("Table elements", this.tableElements), new SearchElementSection("Column elements", this.columnElements)};
    }

    public SearchConditionElement[] getTableElements() {
        return this.tableElements;
    }

    public String getTableTypes() {
        return this.tableTypes;
    }

    public IExportSection<OpenLSavedSearch> mainSection() {
        return this;
    }

    public OpenLSavedSearch restore(IImporter importer) {
        IImportedSection mainSection = importer.readSections(null)[0];
        this.setName(mainSection.getName());
        IImportedSection[] subSections = importer.readSections(mainSection.getId());
        IImportedSection tableTypeSection = subSections[0];
        this.tableTypes = importer.readRows(tableTypeSection.getId())[0][0];
        this.tableElements = OpenLSavedSearch.readSearchElementSection(importer, subSections[1]);
        this.columnElements = OpenLSavedSearch.readSearchElementSection(importer, subSections[2]);
        return this;
    }

    public void setColumnElements(SearchConditionElement[] columnElements) {
        this.columnElements = columnElements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableElements(SearchConditionElement[] tableElements) {
        this.tableElements = tableElements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchElementSection
    implements IExportSection<SearchConditionElement> {
        String name;
        SearchConditionElement[] searchElements;

        private SearchElementSection(String name, SearchConditionElement[] searchElements) {
            this.name = name;
            this.searchElements = searchElements;
        }

        public Class<SearchConditionElement> getExportedClass() {
            return SearchConditionElement.class;
        }

        public String getName() {
            return this.name;
        }

        public IExportRow[] getRows() {
            IExportRow[] exportRows = new IExportRow[this.searchElements.length];
            for (int i = 0; i < this.searchElements.length; ++i) {
                SearchConditionElement searchElement = this.searchElements[i];
                exportRows[i] = new ExportRow(new String[]{searchElement.getType(), String.valueOf(searchElement.isNotFlag()), searchElement.getGroupOperator().getName(), searchElement.getOpType1(), searchElement.getElementValueName(), searchElement.getOpType2(), searchElement.getElementValue()});
            }
            return exportRows;
        }

        public IExportSection<SearchConditionElement>[] getSubSections() {
            return null;
        }
    }
}

