/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import java.util.Map;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.search.ATableSyntaxNodeSelector;
import org.openl.rules.search.SearchConditionElement;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.util.AStringBoolOperator;

public class PropertySelector
extends ATableSyntaxNodeSelector {
    private AStringBoolOperator propertyNameSelector;
    private AStringBoolOperator propertyValueSelector;

    public PropertySelector(SearchConditionElement se) {
        this.propertyNameSelector = se.isAny(se.getElementValueName()) ? null : AStringBoolOperator.makeOperator((String)"matches", (String)se.getElementValueName());
        this.propertyValueSelector = se.isAny(se.getElementValue()) ? null : AStringBoolOperator.makeOperator((String)se.getOpType2(), (String)se.getElementValue());
    }

    private boolean doesPropertyMatch(String propertyName, ITableProperties tableProperties) {
        return !(this.propertyNameSelector != null && !this.propertyNameSelector.isMatching(propertyName) || this.propertyValueSelector != null && !this.propertyValueSelector.isMatching(tableProperties.getPropertyValueAsString(propertyName)));
    }

    public boolean doesTableMatch(TableSyntaxNode tsn) {
        ITableProperties tableProperties = tsn.getTableProperties();
        if (tableProperties == null) {
            return this.propertyNameSelector == null && this.propertyValueSelector == null;
        }
        Map<String, Object> properties = tableProperties.getAllProperties();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String propertName = property.getKey();
            if (!this.doesPropertyMatch(propertName, tableProperties)) continue;
            return true;
        }
        return false;
    }
}

