/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.search;

import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.search.ATableSyntaxNodeSelector;
import org.openl.rules.search.ISearchConstants;
import org.openl.rules.search.PropertySelector;
import org.openl.rules.search.SearchConditionElement;
import org.openl.rules.search.TableHeaderSelector;

public class TableGroupSelector
extends ATableSyntaxNodeSelector
implements ISearchConstants {
    protected SearchConditionElement[] tableElements;
    protected ATableSyntaxNodeSelector[] selectors;

    public TableGroupSelector(SearchConditionElement[] tableElements) {
        this.tableElements = tableElements;
        this.init(tableElements);
    }

    void init(SearchConditionElement[] se) {
        this.selectors = new ATableSyntaxNodeSelector[se.length];
        for (int i = 0; i < se.length; ++i) {
            ATableSyntaxNodeSelector tsnSel;
            this.selectors[i] = tsnSel = this.makeTableSyntaxNodeSelector(se[i]);
        }
    }

    private ATableSyntaxNodeSelector makeTableSyntaxNodeSelector(SearchConditionElement se) {
        if ("header".equals(se.getType())) {
            return new TableHeaderSelector(se);
        }
        if ("property".equals(se.getType())) {
            return new PropertySelector(se);
        }
        throw new RuntimeException("Unknown selector type: " + se.getType());
    }

    public boolean doesTableMatch(TableSyntaxNode node) {
        return new GroupResult().execute(node);
    }

    class GroupResult {
        boolean groupRes = true;
        int idx = 0;

        GroupResult() {
        }

        boolean execute(Object target) {
            boolean res = true;
            while (this.idx < TableGroupSelector.this.tableElements.length) {
                int oldIdx = this.idx;
                boolean x = this.executeGroup(target);
                res = TableGroupSelector.this.tableElements[oldIdx].getGroupOperator().op(res, x);
            }
            return res;
        }

        boolean executeGroup(Object target) {
            boolean res = true;
            int N = TableGroupSelector.this.tableElements.length;
            for (int i = this.idx; i < N; ++i) {
                if (i > this.idx && TableGroupSelector.this.tableElements[i].getGroupOperator().isGroup()) {
                    this.idx = i;
                    return res;
                }
                boolean x = TableGroupSelector.this.selectors[i].select((TableSyntaxNode)target);
                x = TableGroupSelector.this.tableElements[i].isNotFlag() ? !x : x;
                res = i == this.idx ? x : TableGroupSelector.this.tableElements[i].getGroupOperator().op(res, x);
            }
            this.idx = N;
            return res;
        }
    }
}

