/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.GridSplitter;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;

public abstract class AGrid
implements IGrid {
    public static final String RANGE_SEPARATOR = ":";

    public IGridTable[] getTables() {
        return new GridSplitter(this).split();
    }

    public IGridRegion getRegionContaining(int col, int row) {
        int nregions = this.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            IGridRegion reg = this.getMergedRegion(i);
            if (!IGridRegion.Tool.contains(reg, col, row)) continue;
            return reg;
        }
        return null;
    }

    public IGridRegion getRegionStartingAt(int colFrom, int rowFrom) {
        IGridRegion reg = this.getRegionContaining(colFrom, rowFrom);
        if (reg != null && reg.getLeft() == colFrom && reg.getTop() == rowFrom) {
            return reg;
        }
        return null;
    }

    public boolean isPartOfTheMergedRegion(int x, int y) {
        return this.getRegionContaining(x, y) != null;
    }

    public boolean isTopLeftCellInMergedRegion(int column, int row) {
        return this.getRegionStartingAt(column, row) != null;
    }

    public boolean isInOneMergedRegion(int firstCellColumn, int firstCellRow, int secondCellColumn, int secondCellRow) {
        IGridRegion region = this.getRegionContaining(firstCellColumn, firstCellRow);
        return region != null && IGridRegion.Tool.contains(region, secondCellColumn, secondCellRow);
    }
}

