/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ITableTracerObject;
import org.openl.rules.table.xls.formatters.FormattersManager;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.formatters.IFormatter;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.SimpleTracerObject;

public abstract class ATableTracerNode
extends SimpleTracerObject
implements ITableTracerObject {
    public static final String ERROR_RESULT = "ERROR";
    private Object[] params;
    private Object result;
    private Throwable error;

    public ATableTracerNode() {
    }

    public ATableTracerNode(IMemberMetaInfo traceObject, Object[] params) {
        super((Object)traceObject);
        this.params = params;
    }

    protected String asString(IOpenMethod method, int mode) {
        boolean isVoidReturnType;
        StringBuffer buf = new StringBuffer(64);
        buf.append(method.getType().getDisplayName(mode)).append(' ');
        boolean bl = isVoidReturnType = method.getType() == JavaOpenClass.VOID;
        if (!isVoidReturnType) {
            buf.append("= ");
            if (this.hasError()) {
                buf.append(ERROR_RESULT);
            } else {
                buf.append(String.valueOf(this.result));
            }
            buf.append(' ');
        }
        buf.append(method.getName()).append('(');
        IOpenClass[] paramTypes = method.getSignature().getParameterTypes();
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(paramTypes[i].getDisplayName(mode)).append(' ');
            buf.append(method.getSignature().getParameterName(i)).append(" = ");
            IFormatter formatter = FormattersManager.getFormatter(this.params[i]);
            buf.append(formatter.format(this.params[i]));
        }
        buf.append(')');
        return buf.toString();
    }

    public TableSyntaxNode getTableSyntaxNode() {
        ISyntaxNode tsn;
        TableSyntaxNode syntaxNode = null;
        IMemberMetaInfo tracedNode = (IMemberMetaInfo)this.getTraceObject();
        if (tracedNode != null && (tsn = tracedNode.getSyntaxNode()) instanceof TableSyntaxNode) {
            syntaxNode = (TableSyntaxNode)tsn;
        }
        return syntaxNode;
    }

    public ITableTracerObject[] getTableTracers() {
        ITracerObject[] tracerObjects = this.getTracerObjects();
        int size = tracerObjects.length;
        ITableTracerObject[] temp = new ITableTracerObject[size];
        System.arraycopy(tracerObjects, 0, temp, 0, size);
        return temp;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }
}

