/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.CellFont;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.xls.IncorrectFormulaException;

public class FormattedCell
implements ICell {
    private static final Log LOG = LogFactory.getLog(FormattedCell.class);
    private ICell delegate;
    private ICellFont font;
    private ICellStyle style;
    private IGridFilter filter;
    private Object objectValue;
    private String formattedValue;

    public FormattedCell(ICell delegate) {
        this.delegate = delegate;
        try {
            this.objectValue = this.delegate.getObjectValue();
        }
        catch (IncorrectFormulaException e) {
            this.objectValue = "#ERROR";
        }
        this.formattedValue = this.delegate.getStringValue();
        this.font = new CellFont(delegate.getFont());
        this.style = new CellStyle(delegate.getStyle());
    }

    public ICellStyle getStyle() {
        return this.style;
    }

    public ICellFont getFont() {
        return this.font;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public IGridFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IGridFilter filter) {
        if (this.filter != null) {
            LOG.warn((Object)"More than one filter set on cell");
        }
        this.filter = filter;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public int getAbsoluteColumn() {
        return this.delegate.getAbsoluteColumn();
    }

    public int getAbsoluteRow() {
        return this.delegate.getAbsoluteRow();
    }

    public IGridRegion getAbsoluteRegion() {
        return this.delegate.getAbsoluteRegion();
    }

    public int getRow() {
        return this.delegate.getRow();
    }

    public int getColumn() {
        return this.delegate.getColumn();
    }

    public IGridRegion getRegion() {
        return this.delegate.getRegion();
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public String getStringValue() {
        return this.delegate.getStringValue();
    }

    public int getWidth() {
        return this.delegate.getWidth();
    }

    public String getFormula() {
        return this.delegate.getFormula();
    }

    public int getType() {
        return this.delegate.getType();
    }

    public String getUri() {
        return this.delegate.getUri();
    }

    public boolean getNativeBoolean() {
        return this.delegate.getNativeBoolean();
    }

    public double getNativeNumber() {
        return this.delegate.getNativeNumber();
    }

    public int getNativeType() {
        return this.delegate.getNativeType();
    }

    public boolean hasNativeType() {
        return this.delegate.hasNativeType();
    }

    public Date getNativeDate() {
        return this.delegate.getNativeDate();
    }

    public CellMetaInfo getMetaInfo() {
        return this.delegate.getMetaInfo();
    }
}

