/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.IGridRegion;

public class GridRegion
implements IGridRegion {
    int top;
    int left;
    int bottom;
    int right;

    public GridRegion(IGridRegion g) {
        this.top = g.getTop();
        this.left = g.getLeft();
        this.bottom = g.getBottom();
        this.right = g.getRight();
    }

    public GridRegion(int top, int left, int bottom, int right) {
        if (bottom < top) {
            throw new IllegalArgumentException("The bottom row (" + bottom + ") must not be less than the top row(" + top + ").");
        }
        if (right < left) {
            throw new IllegalArgumentException("The right row (" + right + ") must not be less than the left row(" + left + ").");
        }
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public GridRegion(IGridRegion reg, short side, int coord) {
        this(reg);
        switch (side) {
            case 0: {
                this.top = coord;
                break;
            }
            case 1: {
                this.left = coord;
                break;
            }
            case 3: {
                this.right = coord;
                break;
            }
            case 2: {
                this.bottom = coord;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong IGridRegion side argument: " + side);
            }
        }
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public String toString() {
        return "[" + this.getTop() + "," + this.getLeft() + "," + this.getBottom() + "," + this.getRight() + "]";
    }
}

