/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.AGridTable;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;

public class GridTable
extends AGridTable {
    private IGridRegion region;
    private IGrid grid;

    public GridTable(IGridRegion reg, IGrid grid) {
        this.region = reg;
        this.grid = grid;
    }

    public GridTable(int top, int left, int bottom, int right, IGrid grid) {
        this(new GridRegion(top, left, bottom, right), grid);
    }

    public int getWidth() {
        return this.region.getRight() - this.region.getLeft() + 1;
    }

    public int getHeight() {
        return this.region.getBottom() - this.region.getTop() + 1;
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public int getGridColumn(int column, int row) {
        return this.region.getLeft() + column;
    }

    public int getGridRow(int column, int row) {
        return this.region.getTop() + row;
    }

    public IGridRegion getRegion() {
        return this.region;
    }

    public boolean isNormalOrientation() {
        return true;
    }
}

